/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.core.model.animation.ModelPartAnimation;
import com.lycanitesmobs.core.model.animation.TextureLayerAnimation;
import com.lycanitesmobs.core.renderer.IItemModelRenderer;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.RenderProjectileModel;
import com.lycanitesmobs.core.renderer.layer.LayerItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelAnimation {
    public Map<String, TextureLayerAnimation> textureLayers = new HashMap<String, TextureLayerAnimation>();
    public List<ModelPartAnimation> partAnimations = new ArrayList<ModelPartAnimation>();

    public void loadFromJson(JsonObject json) {
        JsonObject jsonObject;
        if (json.has("textureLayers")) {
            Iterator textureLayers = json.get("textureLayers").getAsJsonArray().iterator();
            while (textureLayers.hasNext()) {
                jsonObject = ((JsonElement)textureLayers.next()).getAsJsonObject();
                TextureLayerAnimation animationLayer = new TextureLayerAnimation();
                animationLayer.loadFromJson(jsonObject);
                this.textureLayers.put(animationLayer.name, animationLayer);
            }
        }
        if (json.has("partAnimations")) {
            Iterator partAnimations = json.get("partAnimations").getAsJsonArray().iterator();
            while (partAnimations.hasNext()) {
                jsonObject = ((JsonElement)partAnimations.next()).getAsJsonObject();
                ModelPartAnimation partAnimation = new ModelPartAnimation();
                partAnimation.loadFromJson(jsonObject);
                this.partAnimations.add(partAnimation);
            }
        }
    }

    public void addCreatureLayers(RenderCreature renderer) {
        for (TextureLayerAnimation textureLayer : this.textureLayers.values()) {
            renderer.func_177094_a(textureLayer.createCreatureLayer(renderer));
        }
    }

    public void addProjectileLayers(RenderProjectileModel renderer) {
        for (TextureLayerAnimation textureLayer : this.textureLayers.values()) {
            renderer.addLayer(textureLayer.createProjectileLayer(renderer));
        }
    }

    public void addItemLayers(IItemModelRenderer renderer) {
        for (TextureLayerAnimation textureLayer : this.textureLayers.values()) {
            renderer.addLayer(textureLayer.createItemLayer(renderer));
        }
    }

    public LayerItem getBaseLayer(IItemModelRenderer renderer) {
        TextureLayerAnimation animationLayer;
        if (this.textureLayers.containsKey("base") && (animationLayer = this.textureLayers.get("base")) != null) {
            return animationLayer.createItemLayer(renderer);
        }
        return null;
    }
}

