/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.MobEventSound;
import com.lycanitesmobs.core.gui.GuiOverlay;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.mobevent.MobEvent;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class MobEventPlayerClient {
    public MobEvent mobEvent;
    public int ticks = 0;
    public World world;
    public SimpleSound sound;
    public boolean extended = false;

    public MobEventPlayerClient(MobEvent mobEvent, World world) {
        this.mobEvent = mobEvent;
        this.world = world;
        if (!world.field_72995_K) {
            LycanitesMobs.logWarning("", "Created a MobEventClient with a server side world, this shouldn't happen, things are going to get weird!");
        }
    }

    public void onStart(PlayerEntity player) {
        if (!this.extended) {
            this.ticks = 0;
        }
        String eventMessage = LanguageManager.translate("event." + (this.extended ? "extended" : "started"));
        eventMessage = eventMessage.replace("%event%", this.mobEvent.getTitle());
        player.func_145747_a((ITextComponent)new TranslationTextComponent(eventMessage, new Object[0]));
        if (player.field_71075_bZ.field_75098_d && !MobEventPlayerServer.testOnCreative && "world".equalsIgnoreCase(this.mobEvent.channel)) {
            return;
        }
        this.playSound();
    }

    public void playSound() {
        if (ObjectManager.getSound("mobevent_" + this.mobEvent.title.toLowerCase()) == null) {
            LycanitesMobs.logWarning("MobEvent", "Sound missing for: " + this.mobEvent.getTitle());
            return;
        }
        this.sound = new MobEventSound(ObjectManager.getSound("mobevent_" + this.mobEvent.title.toLowerCase()), SoundCategory.RECORDS, (Entity)ClientManager.getInstance().getClientPlayer(), 1.0f, 1.0f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
    }

    public void onFinish(PlayerEntity player) {
        String eventMessage = LanguageManager.translate("event.finished");
        eventMessage = eventMessage.replace("%event%", this.mobEvent.getTitle());
        player.func_145747_a((ITextComponent)new TranslationTextComponent(eventMessage, new Object[0]));
    }

    public void onUpdate() {
        ++this.ticks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onGUIUpdate(GuiOverlay gui, int sWidth, int sHeight) {
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        if (player.field_71075_bZ.field_75098_d && !MobEventPlayerServer.testOnCreative && "world".equalsIgnoreCase(this.mobEvent.channel)) {
            return;
        }
        if (this.world == null || this.world != player.func_130014_f_()) {
            return;
        }
        if (!this.world.field_72995_K) {
            return;
        }
        int introTime = 240;
        if (this.ticks > introTime) {
            return;
        }
        int startTime = 40;
        int stopTime = 80;
        float animation = 1.0f;
        if (this.ticks < startTime) {
            animation = (float)this.ticks / (float)startTime;
        } else if (this.ticks > introTime - stopTime) {
            animation = (float)(introTime - this.ticks) / (float)stopTime;
        }
        int width = 256;
        int height = 256;
        int x = sWidth / 2 - width / 2;
        int y = sHeight / 2 - height / 2;
        int u = width;
        int v = height;
        x += 3 - this.ticks % 6;
        y += 2 - this.ticks % 4;
        gui.mc.func_110434_K().func_110577_a(this.getTexture());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)animation);
        if (animation > 0.0f) {
            gui.drawTexturedModalRect(x, y, u, v, width, height);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        if (AssetManager.getTexture("guimobevent" + this.mobEvent.title) == null) {
            AssetManager.addTexture("guimobevent" + this.mobEvent.title, LycanitesMobs.modInfo, "textures/mobevents/" + this.mobEvent.title.toLowerCase() + ".png");
        }
        return AssetManager.getTexture("guimobevent" + this.mobEvent.title);
    }
}

