/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.localisation;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.lycanitesmobs.LycanitesMobs;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class LanguageManager {
    public static LanguageManager INSTANCE;
    protected static final Splitter SPLITTER;
    protected static final Pattern PATTERN;
    protected Map<String, String> map = new HashMap<String, String>();

    public static LanguageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LanguageManager();
        }
        return INSTANCE;
    }

    public static String translate(String key) {
        return key;
    }

    public void loadLocaleData(InputStream inputStreamIn) throws IOException {
        if (inputStreamIn == null) {
            return;
        }
        for (String s : IOUtils.readLines((InputStream)inputStreamIn, (Charset)StandardCharsets.UTF_8)) {
            String[] splitters;
            if (s.isEmpty() || s.charAt(0) == '#' || (splitters = (String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)s), String.class)) == null || splitters.length != 2) continue;
            String s1 = splitters[0];
            String s2 = PATTERN.matcher(splitters[1]).replaceAll("%$1s");
            this.map.put(s1, s2);
        }
    }

    public void loadLanguage(String mainLanguage) {
        LycanitesMobs.logDebug("Localisation", "Loading additional lang files...");
        ArrayList languageList = Lists.newArrayList((Object[])new String[]{mainLanguage});
        if (!"en_us".equals(mainLanguage)) {
            languageList.add(mainLanguage);
        }
    }

    static {
        SPLITTER = Splitter.on((char)'=').limit(2);
        PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    }
}

