/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.localisation.LanguageManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SummonEquipmentFeature
extends EquipmentFeature {
    public String summonMobId;
    public double summonChance = 0.05;
    public int summonDuration = 60;
    public int summonCountMin = 1;
    public int summonCountMax = 1;
    public double sizeScale = 1.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.summonMobId = json.get("summonMobId").getAsString();
        if (json.has("summonChance")) {
            this.summonChance = json.get("summonChance").getAsDouble();
        }
        if (json.has("summonDuration")) {
            this.summonDuration = json.get("summonDuration").getAsInt();
        }
        if (json.has("summonCountMin")) {
            this.summonCountMin = json.get("summonCountMin").getAsInt();
        }
        if (json.has("summonCountMax")) {
            this.summonCountMax = json.get("summonCountMax").getAsInt();
        }
        if (json.has("sizeScale")) {
            this.sizeScale = json.get("sizeScale").getAsDouble();
        }
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = LanguageManager.translate("equipment.feature." + this.featureType) + " " + LanguageManager.translate("entity." + this.summonMobId + ".name");
        description = description + "\n" + LanguageManager.translate("equipment.feature.summon.chance") + " " + Math.round(this.summonChance * 100.0) + LanguageManager.translate("common.percent");
        if (this.summonDuration > 0) {
            description = description + "\n" + LanguageManager.translate("equipment.feature.effect.duration") + " " + (float)this.summonDuration / 20.0f;
        }
        description = this.summonCountMin != this.summonCountMax ? description + "\n" + LanguageManager.translate("equipment.feature.summon.count") + " " + this.summonCountMin + " - " + this.summonCountMax : description + "\n" + LanguageManager.translate("equipment.feature.summon.count") + " " + this.summonCountMax;
        return description;
    }

    public void onHitEntity(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (target == null || attacker == null || attacker.func_130014_f_().field_72995_K) {
            return;
        }
        EntityType entityType = null;
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreatureFromId(this.summonMobId);
        if (creatureInfo != null) {
            entityType = creatureInfo.getEntityType();
        } else {
            IForgeRegistryEntry entityTypeObj = GameRegistry.findRegistry(EntityType.class).getValue(new ResourceLocation(this.summonMobId));
            if (entityTypeObj instanceof EntityType) {
                entityType = (EntityType)entityTypeObj;
            }
        }
        if (entityType == null) {
            return;
        }
        if (attacker.func_70681_au().nextDouble() <= this.summonChance) {
            try {
                Entity entity = entityType.func_200721_a(attacker.func_130014_f_());
                entity.func_70012_b((double)attacker.func_180425_c().func_177958_n(), (double)attacker.func_180425_c().func_177956_o(), (double)attacker.func_180425_c().func_177952_p(), attacker.field_70177_z, 0.0f);
                if (entity instanceof EntityCreatureBase) {
                    EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
                    entityCreature.setMinion(true);
                    entityCreature.setTemporary(this.summonDuration * 20);
                    entityCreature.setSizeScale(this.sizeScale);
                    if (attacker instanceof PlayerEntity && entityCreature instanceof EntityCreatureTameable) {
                        EntityCreatureTameable entityTameable = (EntityCreatureTameable)entityCreature;
                        entityTameable.setPlayerOwner((PlayerEntity)attacker);
                        entityTameable.setSitting(false);
                        entityTameable.setFollowing(true);
                        entityTameable.setPassive(false);
                        entityTameable.setAssist(true);
                        entityTameable.setAggressive(true);
                        entityTameable.setPVP(target instanceof PlayerEntity);
                    }
                    float randomAngle = 45.0f + 45.0f * attacker.func_70681_au().nextFloat();
                    if (attacker.func_70681_au().nextBoolean()) {
                        randomAngle = -randomAngle;
                    }
                    BlockPos spawnPos = entityCreature.getFacingPosition((Entity)attacker, -1.0, randomAngle);
                    entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), attacker.field_70177_z, 0.0f);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

