/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class HarvestEquipmentFeature
extends EquipmentFeature {
    private static final Set<Block> SPADE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196874_iZ});
    private static final Set<Block> PICKAXE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    private static final Set<Block> AXE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_196662_n, Blocks.field_150342_X, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_196689_eF, Blocks.field_196663_cq});
    public String harvestType;
    public String harvestShape = "block";
    public float harvestSpeed = 1.0f;
    public int harvestLevel = 3;
    public Vec3i harvestRange = new Vec3i(0, 0, 0);
    public double harvestRangeLevelMultiplier = 1.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.harvestType = json.get("harvestType").getAsString();
        if (json.has("harvestType")) {
            this.harvestType = json.get("harvestType").getAsString();
        }
        if (json.has("harvestSpeed")) {
            this.harvestSpeed = json.get("harvestSpeed").getAsFloat();
        }
        if (json.has("harvestLevel")) {
            this.harvestLevel = json.get("harvestLevel").getAsInt();
        }
        if (json.has("harvestShape")) {
            this.harvestShape = json.get("harvestShape").getAsString();
        }
        this.harvestRange = JSONHelper.getVec3i(json, "harvestRange");
        if (json.has("harvestRangeLevelMultiplier")) {
            this.harvestRangeLevelMultiplier = json.get("harvestRangeLevelMultiplier").getAsDouble();
        }
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = LanguageManager.translate("equipment.feature." + this.featureType) + " " + this.harvestType;
        description = description + "\n" + LanguageManager.translate("equipment.feature.harvest.shape") + " " + this.harvestShape;
        Vec3i vec3i = new Vec3i(0, 0, 0);
        if (this.harvestRange.func_177951_i(vec3i) > 0.0) {
            description = description + "\n" + LanguageManager.translate("equipment.feature.harvest.range") + " " + this.getHarvestRangeString(level);
        }
        return description;
    }

    public String getHarvestRangeString(int level) {
        String harvestRangeString = "" + Math.round((double)this.harvestRange.func_177958_n() + (double)(this.harvestRange.func_177958_n() * (level - 1)) * this.harvestRangeLevelMultiplier);
        harvestRangeString = harvestRangeString + ", " + Math.round((double)this.harvestRange.func_177956_o() + (double)(this.harvestRange.func_177956_o() * (level - 1)) * this.harvestRangeLevelMultiplier);
        harvestRangeString = harvestRangeString + ", " + Math.round((double)this.harvestRange.func_177952_p() + (double)(this.harvestRange.func_177952_p() * (level - 1)) * this.harvestRangeLevelMultiplier);
        return harvestRangeString;
    }

    public boolean canHarvestBlock(BlockState blockState) {
        Block block = blockState.func_177230_c();
        Material material = blockState.func_185904_a();
        if (material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e || PICKAXE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("pickaxe");
        }
        if (material == Material.field_151575_d || AXE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("axe");
        }
        if (material == Material.field_151585_k || material == Material.field_151582_l) {
            return this.harvestType.equalsIgnoreCase("axe") || this.harvestType.equalsIgnoreCase("sword") || this.harvestType.equalsIgnoreCase("shears");
        }
        if (material == Material.field_151569_G || material == Material.field_151584_j || material == Material.field_204868_h) {
            return this.harvestType.equalsIgnoreCase("sword") || this.harvestType.equalsIgnoreCase("shears");
        }
        if (material == Material.field_151578_c || material == Material.field_151571_B || material == Material.field_151595_p || material == Material.field_151577_b || SPADE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("shovel");
        }
        if (material == Material.field_151589_v || material == Material.field_151572_C) {
            return this.harvestType.equalsIgnoreCase("sword");
        }
        if (block == Blocks.field_150473_bD) {
            return this.harvestType.equalsIgnoreCase("shears");
        }
        return false;
    }

    public float getHarvestSpeed(BlockState blockState) {
        if (!this.canHarvestBlock(blockState)) {
            return 0.0f;
        }
        return this.harvestSpeed * this.getHarvestMultiplier(blockState);
    }

    public float getHarvestMultiplier(BlockState blockState) {
        Material material = blockState.func_185904_a();
        if (material == Material.field_151569_G) {
            return 10.0f;
        }
        if ((material == Material.field_151584_j || material == Material.field_151582_l) && this.harvestType.equalsIgnoreCase("shears")) {
            return 10.0f;
        }
        return 1.0f;
    }

    public void onBlockDestroyed(World world, BlockState blockState, BlockPos pos, LivingEntity entityLiving) {
        LycanitesMobs.logWarning("", "Area Harvesting! " + this.harvestRange);
        if (this.harvestShape.equalsIgnoreCase("block") || this.harvestShape.equalsIgnoreCase("random")) {
            if (this.harvestRange.func_177958_n() <= 1 && this.harvestRange.func_177956_o() <= 1 && this.harvestRange.func_177952_p() <= 1) {
                return;
            }
            boolean random = this.harvestShape.equalsIgnoreCase("random");
            for (int x = pos.func_177958_n() - (this.harvestRange.func_177958_n() - 1); x < pos.func_177958_n() + this.harvestRange.func_177958_n(); ++x) {
                for (int y = pos.func_177956_o() - (this.harvestRange.func_177956_o() - 1); y < pos.func_177956_o() + this.harvestRange.func_177956_o(); ++y) {
                    for (int z = pos.func_177952_p() - (this.harvestRange.func_177952_p() - 1); z < pos.func_177952_p() + this.harvestRange.func_177952_p(); ++z) {
                        BlockPos destroyPos = new BlockPos(x, y, z);
                        if (destroyPos.equals((Object)pos) || !this.canHarvestBlock(world.func_180495_p(destroyPos)) || random && world.field_73012_v.nextBoolean()) continue;
                        world.func_175655_b(destroyPos, true);
                    }
                }
            }
            return;
        }
        if (this.harvestShape.equalsIgnoreCase("cross")) {
            BlockPos destroyPos;
            if (this.harvestRange.func_177958_n() > 1) {
                for (int x = pos.func_177958_n() - (this.harvestRange.func_177958_n() - 1); x < pos.func_177958_n() + this.harvestRange.func_177958_n(); ++x) {
                    destroyPos = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p());
                    if (destroyPos.equals((Object)pos) || !this.canHarvestBlock(world.func_180495_p(destroyPos))) continue;
                    world.func_175655_b(destroyPos, true);
                }
            }
            if (this.harvestRange.func_177956_o() > 1) {
                for (int y = pos.func_177956_o() - (this.harvestRange.func_177956_o() - 1); y < pos.func_177956_o() + this.harvestRange.func_177956_o(); ++y) {
                    destroyPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                    if (destroyPos.equals((Object)pos) || !this.canHarvestBlock(world.func_180495_p(destroyPos))) continue;
                    world.func_175655_b(destroyPos, true);
                }
            }
            if (this.harvestRange.func_177952_p() > 1) {
                for (int z = pos.func_177952_p() - (this.harvestRange.func_177952_p() - 1); z < pos.func_177952_p() + this.harvestRange.func_177952_p(); ++z) {
                    destroyPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
                    if (destroyPos.equals((Object)pos) || !this.canHarvestBlock(world.func_180495_p(destroyPos))) continue;
                    world.func_175655_b(destroyPos, true);
                }
            }
        }
    }
}

