/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.localisation.LanguageManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EffectEquipmentFeature
extends EquipmentFeature {
    public String effectType;
    public String effectTarget;
    public int effectDuration = 0;
    public int effectStrength = 0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.effectType = json.get("effectType").getAsString();
        this.effectTarget = json.get("effectTarget").getAsString();
        if (json.has("effectDuration")) {
            this.effectDuration = json.get("effectDuration").getAsInt();
        }
        if (json.has("effectStrength")) {
            this.effectStrength = json.get("effectStrength").getAsInt();
        }
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = LanguageManager.translate("equipment.feature." + this.featureType) + " " + this.effectType + " (" + this.effectTarget + ")";
        if (!"self".equals(this.effectTarget) && this.effectDuration > 0) {
            description = description + "\n" + LanguageManager.translate("equipment.feature.effect.duration") + " " + (float)this.effectDuration / 20.0f;
        }
        if (this.effectStrength > 0) {
            description = description + "\n" + LanguageManager.translate("equipment.feature.effect.strength") + " " + this.effectStrength;
        }
        return description;
    }

    public void onHitEntity(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (target == null || attacker == null) {
            return;
        }
        LivingEntity effectTarget = target;
        if ("self".equalsIgnoreCase(this.effectTarget)) {
            effectTarget = attacker;
        }
        if ("fire".equalsIgnoreCase(this.effectType)) {
            effectTarget.func_70015_d(Math.round((float)this.effectDuration / 20.0f));
            return;
        }
        Effect effect = (Effect)GameRegistry.findRegistry(Effect.class).getValue(new ResourceLocation(this.effectType));
        if (effect != null) {
            effectTarget.func_195064_c(new EffectInstance(effect, this.effectDuration, this.effectStrength));
        }
    }
}

