/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEquipmentPart
extends ItemBase {
    public static Map<String, ItemEquipmentPart> MOB_PART_DROPS = new HashMap<String, ItemEquipmentPart>();
    public List<EquipmentFeature> features = new ArrayList<EquipmentFeature>();
    public String slotType;
    public String dropMobId;
    public float dropChance = 1.0f;
    public int levelMin = 1;
    public int levelMax = 3;

    public ItemEquipmentPart(Item.Properties properties, ModInfo groupInfo) {
        super(properties);
        this.modInfo = groupInfo;
    }

    public void loadFromJSON(JsonObject json) {
        this.itemName = "equipmentpart_" + json.get("itemName").getAsString();
        this.slotType = json.get("slotType").getAsString();
        if (json.has("dropMobId")) {
            this.dropMobId = json.get("dropMobId").getAsString();
            if (!"".equals(this.dropMobId)) {
                MOB_PART_DROPS.put(this.dropMobId, this);
            }
        }
        if (json.has("dropChance")) {
            this.dropChance = json.get("dropChance").getAsFloat();
        }
        if (json.has("levelMin")) {
            this.levelMin = json.get("levelMin").getAsInt();
        }
        if (json.has("levelMax")) {
            this.levelMax = json.get("levelMax").getAsInt();
        }
        if (json.has("features")) {
            JsonArray jsonArray = json.get("features").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject featureJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                if (this.addFeature(EquipmentFeature.createFromJSON(featureJson))) continue;
                LycanitesMobs.logWarning("", "[Equipment] The feature " + featureJson.toString() + " was unable to be added, check the JSON format.");
            }
        }
        this.sortFeatures();
        this.setup();
        AssetManager.addTexture(this.itemName, this.modInfo, "textures/equipment/" + this.itemName + ".png");
    }

    @Override
    public ITextComponent func_200295_i(ItemStack itemStack) {
        String displayName = LanguageManager.translate(this.func_77667_c(itemStack) + ".name");
        displayName = displayName + " " + LanguageManager.translate("equipment.level") + " " + this.getLevel(itemStack);
        return new TranslationTextComponent(displayName, new Object[0]);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (String description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c("-------------------\n" + description, descriptionWidth);
            for (String formattedDescription : formattedDescriptionList) {
                tooltip.add((ITextComponent)new TranslationTextComponent(formattedDescription, new Object[0]));
            }
        }
    }

    @Override
    public String getDescription(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        return LanguageManager.translate("item.equipmentpart.description");
    }

    public List<String> getAdditionalDescriptions(ItemStack itemStack, @Nullable World world, ITooltipFlag tooltipFlag) {
        ArrayList<String> descriptions = new ArrayList<String>();
        int level = this.getLevel(itemStack);
        String baseFeature = LanguageManager.translate("equipment.slottype") + " " + this.slotType;
        baseFeature = baseFeature + "\n" + LanguageManager.translate("equipment.level") + " " + level + "/" + this.levelMax;
        descriptions.add(baseFeature);
        for (EquipmentFeature feature : this.features) {
            String featureDescription = feature.getDescription(itemStack, level);
            if (featureDescription == null || "".equals(featureDescription)) continue;
            descriptions.add(featureDescription);
        }
        return descriptions;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public CompoundNBT getTagCompound(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p();
        }
        return new CompoundNBT();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientManager.getInstance().getFontRenderer();
    }

    public void initializePart(World world, ItemStack itemStack) {
        int level = this.levelMax;
        if (this.levelMin < this.levelMax) {
            level = this.levelMin + world.field_73012_v.nextInt(this.levelMax - this.levelMin + 1);
        }
        this.setLevel(itemStack, level);
    }

    public boolean addFeature(EquipmentFeature feature) {
        if (feature == null) {
            LycanitesMobs.logWarning("", "[Equipment] Unable to add a null feature to " + (Object)((Object)this));
            return false;
        }
        if (feature.featureType == null) {
            LycanitesMobs.logWarning("", "[Equipment] Feature type not set for part " + (Object)((Object)this));
            return false;
        }
        this.features.add(feature);
        return true;
    }

    public void sortFeatures() {
        Comparator comparator = (o1, o2) -> o1.featureType.compareToIgnoreCase(o2.featureType);
        this.features.sort(comparator);
    }

    public void setLevel(ItemStack itemStack, int level) {
        CompoundNBT nbt = this.getTagCompound(itemStack);
        if (!nbt.func_74764_b("equipmentLevel")) {
            nbt.func_74768_a("equipmentLevel", level);
        }
        itemStack.func_77982_d(nbt);
    }

    public int getLevel(ItemStack itemStack) {
        CompoundNBT nbt = this.getTagCompound(itemStack);
        int level = 1;
        if (nbt.func_74764_b("equipmentLevel")) {
            level = nbt.func_74762_e("equipmentLevel");
        }
        return level;
    }

    public Vector4f getColor(ItemStack itemStack) {
        CompoundNBT nbt = this.getTagCompound(itemStack);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (nbt.func_74764_b("equipmentColorR")) {
            r = nbt.func_74760_g("equipmentColorR");
        }
        if (nbt.func_74764_b("equipmentColorG")) {
            r = nbt.func_74760_g("equipmentColorG");
        }
        if (nbt.func_74764_b("equipmentColorB")) {
            r = nbt.func_74760_g("equipmentColorB");
        }
        return new Vector4f(r, g, b, 1.0f);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int level = 1; level <= this.levelMax; ++level) {
            ItemStack itemStack = new ItemStack((IItemProvider)this, 1);
            this.setLevel(itemStack, level);
            items.add((Object)itemStack);
        }
    }

    public ResourceLocation getTexture(ItemStack itemStack, String suffix) {
        String textureName = this.itemName.toLowerCase().replace("equipmentpart_", "") + suffix;
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.modInfo, "textures/equipment/" + textureName + ".png");
        }
        return AssetManager.getTexture(textureName);
    }
}

