/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.common.collect.Multimap;
import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.item.equipment.features.DamageEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.EffectEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.HarvestEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.ProjectileEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.SummonEquipmentFeature;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemEquipment
extends ItemBase {
    public static int PART_LIMIT = 20;

    public ItemEquipment(Item.Properties properties) {
        super(properties);
        this.itemName = "equipment";
        this.modInfo = LycanitesMobs.modInfo;
        this.setRegistryName(this.modInfo.modid, this.itemName);
        properties.func_200917_a(1);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (String description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c("" + description, descriptionWidth);
            for (String formattedDescription : formattedDescriptionList) {
                tooltip.add((ITextComponent)new TranslationTextComponent(formattedDescription, new Object[0]));
            }
        }
    }

    @Override
    public String getDescription(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        return LanguageManager.translate("item.equipment.description");
    }

    public List<String> getAdditionalDescriptions(ItemStack itemStack, @Nullable World world, ITooltipFlag tooltipFlag) {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(itemStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            int partLevel = equipmentPart.getLevel(equipmentPartStack);
            descriptions.add(equipmentPart.func_200295_i(itemStack) + " " + LanguageManager.translate("entity.level") + " " + partLevel);
        }
        return descriptions;
    }

    public CompoundNBT getTagCompound(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p();
        }
        return new CompoundNBT();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientManager.getInstance().getFontRenderer();
    }

    public NonNullList<ItemStack> getEquipmentPartStacks(ItemStack itemStack) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)PART_LIMIT, (Object)ItemStack.field_190927_a);
        CompoundNBT nbt = this.getTagCompound(itemStack);
        if (nbt.func_74764_b("Items")) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)itemStacks);
        }
        return itemStacks;
    }

    public int getEquipmentPartCount(ItemStack itemStack) {
        int partCount = 0;
        for (ItemStack partStack : this.getEquipmentPartStacks(itemStack)) {
            if (partStack.func_190926_b()) continue;
            ++partCount;
        }
        return partCount;
    }

    public ItemEquipmentPart getEquipmentPart(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (!(itemStack.func_77973_b() instanceof ItemEquipmentPart)) {
            return null;
        }
        return (ItemEquipmentPart)itemStack.func_77973_b();
    }

    public void addEquipmentPart(ItemStack equipmentStack, ItemStack equipmentPartStack, int slotIndex) {
        if (slotIndex >= PART_LIMIT) {
            return;
        }
        NonNullList<ItemStack> itemStacks = this.getEquipmentPartStacks(equipmentStack);
        itemStacks.set(slotIndex, (Object)equipmentPartStack);
        CompoundNBT nbt = this.getTagCompound(equipmentStack);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, itemStacks);
        equipmentStack.func_77982_d(nbt);
    }

    public List<EquipmentFeature> getFeaturesByType(ItemStack equipmentStack, String featureType) {
        ArrayList<EquipmentFeature> features = new ArrayList<EquipmentFeature>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            for (EquipmentFeature feature : equipmentPart.features) {
                if (!feature.isActive(equipmentPartStack, equipmentPart.getLevel(equipmentPartStack)) || !feature.featureType.equalsIgnoreCase(featureType)) continue;
                features.add(feature);
            }
        }
        return features;
    }

    public void applyLevelCap(ItemStack equipmentStack, int levelCap) {
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            equipmentPart.setLevel(equipmentPartStack, Math.min(levelCap, equipmentPart.getLevel(equipmentPartStack)));
        }
    }

    public int getHighestLevel(ItemStack equipmentStack) {
        int highestLevel = 0;
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            int partLevel;
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null || (partLevel = equipmentPart.getLevel(equipmentPartStack)) <= highestLevel) continue;
            highestLevel = partLevel;
        }
        return highestLevel;
    }

    @Override
    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(ItemStack stack) {
        return 18000;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        boolean active = false;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            if (!projectileFeature.onUseSecondary(world, player, hand)) continue;
            active = true;
        }
        if (active) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.PASS, (Object)itemStack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
    }

    @Override
    public void onUsingTick(ItemStack itemStack, LivingEntity user, int count) {
        if (!user.func_184587_cr()) {
            return;
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            projectileFeature.onHoldSecondary(user, count);
        }
    }

    @Nonnull
    public Set<ToolType> getToolTypes(ItemStack itemStack) {
        return super.getToolTypes(itemStack);
    }

    public boolean canHarvestBlock(ItemStack itemStack, BlockState blockState) {
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            if (!harvestFeature.canHarvestBlock(blockState)) continue;
            return true;
        }
        return false;
    }

    public float func_150893_a(ItemStack itemStack, BlockState blockState) {
        float speed = 1.0f;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            speed += harvestFeature.getHarvestSpeed(blockState);
        }
        return speed;
    }

    public boolean func_179218_a(ItemStack itemStack, World worldIn, BlockState blockState, BlockPos pos, LivingEntity entityLiving) {
        if (worldIn.field_72995_K) {
            return super.func_179218_a(itemStack, worldIn, blockState, pos, entityLiving);
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            harvestFeature.onBlockDestroyed(worldIn, blockState, pos, entityLiving);
        }
        return super.func_179218_a(itemStack, worldIn, blockState, pos, entityLiving);
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        double knockback = this.getDamageKnockback(itemStack);
        if (knockback != 0.0 && attacker != null && target != null) {
            double xDist = attacker.field_70165_t - target.field_70165_t;
            double zDist = attacker.field_70161_v - target.field_70161_v;
            double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
            double motionCap = 10.0;
            if (target.func_213322_ci().func_82615_a() < motionCap && target.func_213322_ci().func_82615_a() > -motionCap && target.func_213322_ci().func_82616_c() < motionCap && target.func_213322_ci().func_82616_c() > -motionCap) {
                target.func_70024_g(-(xDist / xzDist * knockback + target.func_213322_ci().func_82615_a() * knockback), 0.0, -(zDist / xzDist * knockback + target.func_213322_ci().func_82616_c() * knockback));
            }
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "effect")) {
            EffectEquipmentFeature effectFeature = (EffectEquipmentFeature)equipmentFeature;
            effectFeature.onHitEntity(itemStack, target, attacker);
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "summon")) {
            SummonEquipmentFeature summonFeature = (SummonEquipmentFeature)equipmentFeature;
            summonFeature.onHitEntity(itemStack, target, attacker);
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            projectileFeature.onHitEntity(itemStack, target, attacker);
        }
        return true;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(slot, itemStack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getDamageAmount(itemStack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -this.getDamageCooldown(itemStack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public double getDamageAmount(ItemStack itemStack) {
        double damage = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            damage += (double)damageFeature.damageAmount;
        }
        return damage;
    }

    public double getDamageCooldown(ItemStack itemStack) {
        double cooldown = 0.0;
        double i = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            cooldown += damageFeature.damageCooldown;
            i += 1.0;
        }
        if (i == 0.0) {
            return 2.4;
        }
        cooldown = 2.4 * (cooldown / i);
        return cooldown;
    }

    public double getDamageKnockback(ItemStack itemStack) {
        double knockback = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            knockback += damageFeature.damageKnockback;
        }
        return knockback;
    }

    public ResourceLocation getTexture(ItemStack itemStack) {
        return AssetManager.getTexture(this.itemName);
    }
}

