/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.renderer.EquipmentPartRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;

public class EquipmentPartManager
extends JSONLoader {
    public static EquipmentPartManager INSTANCE;
    public Map<String, ItemEquipmentPart> equipmentParts = new HashMap<String, ItemEquipmentPart>();
    public List<ModInfo> loadedGroups = new ArrayList<ModInfo>();

    public static EquipmentPartManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EquipmentPartManager();
        }
        return INSTANCE;
    }

    public void loadAllFromJSON(ModInfo groupInfo) {
        if (!this.loadedGroups.contains(groupInfo)) {
            this.loadedGroups.add(groupInfo);
        }
        this.loadAllJson(groupInfo, "Equipment", "equipment", "itemName", false, null, FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Equipment", "Complete! " + this.equipmentParts.size() + " JSON Equipment Parts Loaded In Total.");
    }

    @Override
    public void parseJson(ModInfo groupInfo, String name, JsonObject json) {
        Item.Properties properties = new Item.Properties().func_200917_a(1).setNoRepair().func_200916_a(ItemManager.getInstance().equipmentParts).setTEISR(() -> EquipmentPartRenderer::new);
        ItemEquipmentPart equipmentPart = new ItemEquipmentPart(properties, groupInfo);
        equipmentPart.loadFromJSON(json);
        if (this.equipmentParts.containsKey(equipmentPart.itemName)) {
            LycanitesMobs.logWarning("", "[Equipment] Tried to add a Equipment Part with a name that is already in use: " + equipmentPart.itemName);
            throw new RuntimeException("[Equipment] Tried to add a Equipment Part with a name that is already in use: " + equipmentPart.itemName);
        }
        if (this.equipmentParts.values().contains((Object)equipmentPart)) {
            LycanitesMobs.logWarning("", "[Equipment] Tried to add a Equipment Part that is already added: " + equipmentPart.itemName);
            throw new RuntimeException("[Equipment] Tried to add a Equipment Part that is already added: " + equipmentPart.itemName);
        }
        this.equipmentParts.put(equipmentPart.itemName, equipmentPart);
        ObjectManager.addItem(equipmentPart.itemName, equipmentPart);
    }

    public void reload() {
        this.equipmentParts.clear();
        for (ModInfo group : this.loadedGroups) {
            this.loadAllFromJSON(group);
        }
    }
}

