/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.consumable;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemWinterGift
extends ItemBase {
    public ItemWinterGift(Item.Properties properties) {
        super(properties);
        this.modInfo = LycanitesMobs.modInfo;
        this.itemName = "wintergift";
        this.setup();
        ObjectManager.addSound(this.itemName + "_good", this.modInfo, "item." + this.itemName + ".good");
        ObjectManager.addSound(this.itemName + "_bad", this.modInfo, "item." + this.itemName + ".bad");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
        }
        if (!world.field_72995_K) {
            if (player.func_70681_au().nextBoolean()) {
                this.openGood(itemStack, world, player);
            } else {
                this.openBad(itemStack, world, player);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    public void openGood(ItemStack itemStack, World world, PlayerEntity player) {
        String message = LanguageManager.translate("item." + this.itemName + ".good");
        player.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[0]));
        this.playSound(world, player.func_180425_c(), ObjectManager.getSound(this.itemName + "_good"), SoundCategory.AMBIENT, 5.0f, 1.0f);
        List<ItemStack> dropStacks = ObjectLists.getItems("winter_gifts");
        if (dropStacks == null || dropStacks.isEmpty()) {
            return;
        }
        ItemStack dropStack = dropStacks.get(player.func_70681_au().nextInt(dropStacks.size()));
        dropStack.func_190920_e(1 + player.func_70681_au().nextInt(4));
        EntityItemCustom entityItem = new EntityItemCustom(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropStack);
        entityItem.func_174867_a(10);
        world.func_217376_c((Entity)entityItem);
    }

    public void openBad(ItemStack itemStack, World world, PlayerEntity player) {
        Entity entity;
        String message = LanguageManager.translate("item." + this.itemName + ".bad");
        player.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[0]));
        this.playSound(world, player.func_180425_c(), ObjectManager.getSound(this.itemName + "_bad"), SoundCategory.AMBIENT, 5.0f, 1.0f);
        List<EntityType> entityTypes = ObjectLists.getEntites("winter_tricks");
        if (entityTypes.isEmpty()) {
            return;
        }
        EntityType entityType = entityTypes.get(player.func_70681_au().nextInt(entityTypes.size()));
        if (entityType != null && (entity = entityType.func_200721_a(world)) != null) {
            entity.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            if (entity instanceof EntityCreatureBase) {
                EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
                entityCreature.addLevel(world.field_73012_v.nextInt(10));
                if (entityCreature.creatureInfo.getName().equals("wildkin")) {
                    entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent("Gooderness", new Object[0]));
                } else if (entityCreature.creatureInfo.getName().equals("jabberwock")) {
                    entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent("Rudolph", new Object[0]));
                } else if (entityCreature.creatureInfo.getName().equals("ent")) {
                    entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent("Salty Tree", new Object[0]));
                } else if (entityCreature.creatureInfo.getName().equals("treant")) {
                    entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent("Salty Tree", new Object[0]));
                } else if (entityCreature.creatureInfo.getName().equals("phantom")) {
                    entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent("Satan Claws", new Object[0]));
                } else if (entityCreature.creatureInfo.getName().equals("behemoth")) {
                    entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent("Krampus", new Object[0]));
                }
            }
            world.func_217376_c(entity);
        }
    }

    public static void createObjectLists() {
        ObjectLists.addItem("winter_gifts", Items.field_151045_i);
        ObjectLists.addItem("winter_gifts", Items.field_151043_k);
        ObjectLists.addItem("winter_gifts", Items.field_151166_bC);
        ObjectLists.addItem("winter_gifts", Blocks.field_150339_S);
        ObjectLists.addItem("winter_gifts", Items.field_151079_bi);
        ObjectLists.addItem("winter_gifts", Items.field_151072_bj);
        ObjectLists.addItem("winter_gifts", Items.field_151114_aO);
        ObjectLists.addItem("winter_gifts", Items.field_151044_h);
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("mosspie"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("ambercake"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("peakskebab"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("bulwarkburger"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("palesoup"));
        ObjectLists.addFromConfig("winter_gifts");
        ObjectLists.addEntity("winter_tricks", "wildkin");
        ObjectLists.addEntity("winter_tricks", "jabberwock");
        ObjectLists.addEntity("winter_tricks", "ent");
        ObjectLists.addEntity("winter_tricks", "treant");
        ObjectLists.addEntity("winter_tricks", "phantom");
        ObjectLists.addEntity("winter_tricks", "behemoth");
    }
}

