/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;

public class ItemCustomSpawnEgg
extends ItemBase {
    public CreatureType creatureType;

    public ItemCustomSpawnEgg(Item.Properties properties, String name, CreatureType creatureType) {
        super(properties);
        this.itemName = name;
        this.creatureType = creatureType;
        this.setRegistryName(this.modInfo.modid, this.itemName);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenserBehaviorMobEggCustom());
        LycanitesMobs.logDebug("Creature Type", "Created Creature Type Spawn Egg: " + this.itemName);
    }

    @Override
    public ITextComponent func_200295_i(ItemStack itemStack) {
        String displayName = LanguageManager.translate("creaturetype.spawn") + " " + this.creatureType.getTitle() + ": ";
        CreatureInfo creatureInfo = this.getCreatureInfo(itemStack);
        displayName = creatureInfo != null ? displayName + creatureInfo.getTitle() : displayName + "Missing Creature NBT";
        return new TranslationTextComponent(displayName, new Object[0]);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        String description = this.getDescription(stack, worldIn, tooltip, flag);
        if (!"".equalsIgnoreCase(description) && !("item." + this.itemName + ".description").equals(description)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List formattedDescriptionList = fontRenderer.func_78271_c(description, ItemBase.descriptionWidth);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent((String)formattedDescription, new Object[0]));
            }
        }
    }

    @Override
    public String getDescription(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CreatureInfo creatureInfo = this.getCreatureInfo(itemStack);
        if (creatureInfo == null) {
            String creatureName = this.getCreatureName(itemStack);
            LycanitesMobs.logWarning("Mob Spawn Egg", "Unable to get Creature Info for id: " + creatureName);
            return "Unable to get Creature Info for id: '" + creatureName + "' this spawn egg may have been created by a give command without NBT data.";
        }
        return creatureInfo.getDescription();
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (CreatureInfo creatureInfo : this.creatureType.creatures.values()) {
            ItemStack itemstack = new ItemStack((IItemProvider)this, 1);
            this.applyCreatureInfoToItemStack(itemstack, creatureInfo);
            items.add((Object)itemstack);
        }
    }

    public void applyCreatureInfoToItemStack(ItemStack itemStack, CreatureInfo creatureInfo) {
        CompoundNBT itemStackNBT = itemStack.func_77942_o() ? itemStack.func_77978_p() : new CompoundNBT();
        CompoundNBT spawnEggNBT = new CompoundNBT();
        spawnEggNBT.func_74778_a("creaturename", creatureInfo.getName());
        itemStackNBT.func_218657_a("CreatureInfoSpawnEgg", (INBT)spawnEggNBT);
        itemStack.func_77982_d(itemStackNBT);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        LivingEntity entity;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(context.func_196000_l()), context.func_196000_l(), itemStack)) {
            return ActionResultType.FAIL;
        }
        if (block == Blocks.field_150474_ac) {
            TileEntity tileEntity = world.func_175625_s(pos);
            AbstractSpawner mobspawnerbaselogic = ((MobSpawnerTileEntity)tileEntity).func_145881_a();
            mobspawnerbaselogic.func_200876_a(this.getCreatureInfo(itemStack).getEntityType());
            tileEntity.func_70296_d();
            world.func_184138_a(pos, blockState, blockState, 3);
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
            return ActionResultType.SUCCESS;
        }
        pos = pos.func_177972_a(context.func_196000_l());
        double d0 = 0.0;
        if (context.func_196000_l() == Direction.UP && blockState.func_177230_c() instanceof FenceBlock) {
            d0 = 0.5;
        }
        if ((entity = this.spawnCreature(world, itemStack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (itemStack.func_82837_s()) {
                entity.func_200203_b(itemStack.func_200301_q());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)itemStack);
        }
        RayTraceResult rayTraceResult = ItemCustomSpawnEgg.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)itemStack);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        BlockPos pos = blockRayTraceResult.func_216350_a();
        if (!world.canMineBlockBody(player, pos)) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
        }
        if (!player.func_175151_a(pos, blockRayTraceResult.func_216354_b(), itemStack)) {
            return new ActionResult(ActionResultType.PASS, (Object)itemStack);
        }
        if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            LivingEntity entity = this.spawnCreature(world, itemStack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (entity != null && itemStack.func_82837_s()) {
                entity.func_200203_b(itemStack.func_200301_q());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    public CreatureInfo getCreatureInfo(ItemStack itemStack) {
        String creatureName = this.getCreatureName(itemStack);
        return CreatureManager.getInstance().getCreature(creatureName);
    }

    public String getCreatureName(ItemStack itemStack) {
        CompoundNBT itemStackNBT = itemStack.func_77978_p();
        if (itemStackNBT == null || !itemStackNBT.func_150297_b("CreatureInfoSpawnEgg", 10)) {
            return null;
        }
        CompoundNBT spawnEggNBT = itemStackNBT.func_74775_l("CreatureInfoSpawnEgg");
        return !spawnEggNBT.func_150297_b("creaturename", 8) ? null : spawnEggNBT.func_74779_i("creaturename");
    }

    public LivingEntity spawnCreature(World world, ItemStack itemStack, double x, double y, double z) {
        LivingEntity entity = this.getCreatureInfo(itemStack).createEntity(world);
        if (entity != null) {
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70761_aq = entity.field_70177_z;
            if (itemStack.func_82837_s()) {
                entity.func_200203_b(itemStack.func_200301_q());
            }
            if (entity instanceof MobEntity) {
                MobEntity mobEntity = (MobEntity)entity;
                mobEntity.func_213386_a((IWorld)world, world.func_175649_E(new BlockPos((Entity)mobEntity)), SpawnReason.SPAWN_EGG, null, null);
                mobEntity.func_70642_aH();
            }
            world.func_217376_c((Entity)entity);
        }
        return entity;
    }
}

