/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.ItemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemCharge
extends ItemBase {
    public ProjectileInfo projectileInfo;
    public Class<? extends EntityProjectileBase> oldProjectileClass;

    public ItemCharge(Item.Properties properties, ProjectileInfo projectileInfo) {
        super(properties);
        this.projectileInfo = projectileInfo;
        this.modInfo = LycanitesMobs.modInfo;
        if (this.projectileInfo != null) {
            this.itemName = projectileInfo.chargeItemName;
            LycanitesMobs.logDebug("Projectile", "Created Charge Item: " + projectileInfo.chargeItemName);
            this.setup();
        }
    }

    public ItemCharge(Item.Properties properties, String itemName, Class<? extends EntityProjectileBase> projectileClass) {
        super(properties);
        this.oldProjectileClass = projectileClass;
        this.modInfo = LycanitesMobs.modInfo;
        this.itemName = itemName;
        this.setup();
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
        }
        if (!world.field_72995_K) {
            EntityProjectileBase projectile = this.createProjectile(itemStack, world, player);
            if (projectile == null) {
                LycanitesMobs.logWarning("", "Failed to create projectile from Charge Item: " + this.itemName);
                return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
            }
            world.func_217376_c((Entity)projectile);
            this.playSound(world, player.func_180425_c(), projectile.getLaunchSound(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    public EntityProjectileBase createProjectile(ItemStack itemStack, World world, PlayerEntity entityPlayer) {
        if (this.projectileInfo != null) {
            return this.projectileInfo.createProjectile(world, (LivingEntity)entityPlayer);
        }
        if (this.oldProjectileClass != null) {
            return ProjectileManager.getInstance().createOldProjectile(this.oldProjectileClass, world, (LivingEntity)entityPlayer);
        }
        return null;
    }
}

