/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ProjectileBehaviourPlaceBlocks
extends ProjectileBehaviour {
    public String blockName;
    public double chance = 1.0;
    public int radius = 1;
    public int height = 1;

    @Override
    public void loadFromJSON(JsonObject json) {
        this.blockName = json.get("block").getAsString();
        if (json.has("chance")) {
            this.chance = json.get("chance").getAsDouble();
        }
        if (json.has("radius")) {
            this.radius = json.get("radius").getAsInt();
        }
        if (json.has("height")) {
            this.height = json.get("height").getAsInt();
        }
    }

    @Override
    public void onProjectileImpact(EntityProjectileBase projectile, World world, BlockPos pos) {
        Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(this.blockName));
        if (block == null) {
            return;
        }
        pos = pos.func_177984_a();
        for (int x = -this.radius + 1; x < this.radius; ++x) {
            for (int y = this.height - 1; y < this.height; ++y) {
                for (int z = -this.radius + 1; z < this.radius; ++z) {
                    BlockPos placePos = pos.func_177982_a(x, y, z);
                    if (!projectile.canDestroyBlock(placePos) || !(this.chance >= 1.0) && !(this.chance >= world.field_73012_v.nextDouble())) continue;
                    world.func_175656_a(placePos, block.func_176223_P());
                }
            }
        }
    }
}

