/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviourPlaceBlocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ProjectileBehaviour {
    public String type;

    public static ProjectileBehaviour createFromJSON(JsonObject json) {
        String type = json.get("type").getAsString();
        ProjectileBehaviourPlaceBlocks projectileBehaviour = null;
        if ("placeBlocks".equals(type)) {
            projectileBehaviour = new ProjectileBehaviourPlaceBlocks();
        }
        if (projectileBehaviour == null) {
            return null;
        }
        projectileBehaviour.type = type;
        ((ProjectileBehaviour)projectileBehaviour).loadFromJSON(json);
        return projectileBehaviour;
    }

    public abstract void loadFromJSON(JsonObject var1);

    public void onProjectileUpdate(EntityProjectileBase projectile) {
    }

    public void onProjectileImpact(EntityProjectileBase projectile, World world, BlockPos pos) {
    }
}

