/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorProjectile;
import com.lycanitesmobs.core.entity.EntityFactory;
import com.lycanitesmobs.core.entity.EntityPortal;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.EntityProjectileModel;
import com.lycanitesmobs.core.entity.EntityProjectileRapidFire;
import com.lycanitesmobs.core.entity.projectile.EntityAcidSplash;
import com.lycanitesmobs.core.entity.projectile.EntityAetherwave;
import com.lycanitesmobs.core.entity.projectile.EntityAquaPulse;
import com.lycanitesmobs.core.entity.projectile.EntityArcaneLaser;
import com.lycanitesmobs.core.entity.projectile.EntityArcaneLaserEnd;
import com.lycanitesmobs.core.entity.projectile.EntityArcaneLaserStorm;
import com.lycanitesmobs.core.entity.projectile.EntityBlizzard;
import com.lycanitesmobs.core.entity.projectile.EntityBloodleech;
import com.lycanitesmobs.core.entity.projectile.EntityBoulderBlast;
import com.lycanitesmobs.core.entity.projectile.EntityChaosOrb;
import com.lycanitesmobs.core.entity.projectile.EntityCrystalShard;
import com.lycanitesmobs.core.entity.projectile.EntityDemonicBlast;
import com.lycanitesmobs.core.entity.projectile.EntityDemonicSpark;
import com.lycanitesmobs.core.entity.projectile.EntityDevilGatling;
import com.lycanitesmobs.core.entity.projectile.EntityDevilstar;
import com.lycanitesmobs.core.entity.projectile.EntityDoomfireball;
import com.lycanitesmobs.core.entity.projectile.EntityFaeBolt;
import com.lycanitesmobs.core.entity.projectile.EntityFrostbolt;
import com.lycanitesmobs.core.entity.projectile.EntityFrostweb;
import com.lycanitesmobs.core.entity.projectile.EntityHellLaser;
import com.lycanitesmobs.core.entity.projectile.EntityHellLaserEnd;
import com.lycanitesmobs.core.entity.projectile.EntityHellShield;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireBarrier;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireBarrierPart;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireOrb;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWall;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWave;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWavePart;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireball;
import com.lycanitesmobs.core.entity.projectile.EntityIcefireball;
import com.lycanitesmobs.core.entity.projectile.EntityLifeDrain;
import com.lycanitesmobs.core.entity.projectile.EntityLifeDrainEnd;
import com.lycanitesmobs.core.entity.projectile.EntityLightBall;
import com.lycanitesmobs.core.entity.projectile.EntityMagma;
import com.lycanitesmobs.core.entity.projectile.EntityMudshot;
import com.lycanitesmobs.core.entity.projectile.EntityPoisonRay;
import com.lycanitesmobs.core.entity.projectile.EntityPoisonRayEnd;
import com.lycanitesmobs.core.entity.projectile.EntityPoop;
import com.lycanitesmobs.core.entity.projectile.EntityQuill;
import com.lycanitesmobs.core.entity.projectile.EntityScorchfireball;
import com.lycanitesmobs.core.entity.projectile.EntitySpectralbolt;
import com.lycanitesmobs.core.entity.projectile.EntityThrowingScythe;
import com.lycanitesmobs.core.entity.projectile.EntityTundra;
import com.lycanitesmobs.core.entity.projectile.EntityWaterJet;
import com.lycanitesmobs.core.entity.projectile.EntityWaterJetEnd;
import com.lycanitesmobs.core.entity.projectile.EntityWhirlwind;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.item.ItemCharge;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ProjectileManager
extends JSONLoader {
    public static ProjectileManager INSTANCE;
    public Map<String, ProjectileInfo> projectiles = new HashMap<String, ProjectileInfo>();
    public Map<String, Class<? extends Entity>> oldSpriteProjectiles = new HashMap<String, Class<? extends Entity>>();
    public Map<String, Class<? extends Entity>> oldModelProjectiles = new HashMap<String, Class<? extends Entity>>();
    public Map<Class<? extends Entity>, EntityType<? extends EntityProjectileBase>> oldProjectileTypes = new HashMap<Class<? extends Entity>, EntityType<? extends EntityProjectileBase>>();
    protected int nextProjectileNetworkId = 1000;

    public static ProjectileManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProjectileManager();
        }
        return INSTANCE;
    }

    public void startup(ModInfo modInfo) {
        this.loadAllFromJSON(modInfo);
        for (ProjectileInfo projectileInfo : this.projectiles.values()) {
            projectileInfo.load();
        }
        try {
            ObjectManager.addSpecialEntity("rapidfire", EntityProjectileRapidFire.class, EntityProjectileRapidFire.class.getConstructor(EntityType.class, World.class));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.loadOldProjectiles();
    }

    public void loadAllFromJSON(ModInfo groupInfo) {
        this.loadAllJson(groupInfo, "Projectile", "projectiles", "name", true, null, FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Projectile", "Complete! " + this.projectiles.size() + " JSON Projectile Info Loaded In Total.");
    }

    @Override
    public void parseJson(ModInfo modInfo, String name, JsonObject json) {
        ProjectileInfo projectileInfo = new ProjectileInfo(modInfo);
        projectileInfo.loadFromJSON(json);
        if (projectileInfo.name == null) {
            LycanitesMobs.logWarning("", "[Projectile] Unable to load " + name + " json due to missing name.");
            return;
        }
        if (this.projectiles.containsKey(projectileInfo.name)) {
            projectileInfo = this.projectiles.get(projectileInfo.name);
            projectileInfo.loadFromJSON(json);
        }
        this.projectiles.put(projectileInfo.name, projectileInfo);
    }

    public int getNextProjectileNetworkId() {
        return this.nextProjectileNetworkId++;
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        EntityType entityType;
        EntityType.Builder entityTypeBuilder;
        String registryName;
        LycanitesMobs.logDebug("Projectile", "Forge registering all " + this.projectiles.size() + " projectiles...");
        for (ProjectileInfo projectileInfo : this.projectiles.values()) {
            event.getRegistry().register(projectileInfo.getEntityType());
        }
        for (String entityName : this.oldSpriteProjectiles.keySet()) {
            registryName = LycanitesMobs.modInfo.modid + ":" + entityName;
            entityTypeBuilder = EntityType.Builder.func_220322_a((EntityType.IFactory)EntityFactory.getInstance(), (EntityClassification)EntityClassification.MISC);
            entityTypeBuilder.setTrackingRange(40);
            entityTypeBuilder.setUpdateInterval(3);
            entityTypeBuilder.setShouldReceiveVelocityUpdates(true);
            entityType = entityTypeBuilder.func_206830_a(entityName);
            entityType.setRegistryName("lycanitesmobs", entityName);
            try {
                EntityFactory.getInstance().addEntityType(entityType, this.oldSpriteProjectiles.get(entityName).getConstructor(EntityType.class, World.class));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.oldProjectileTypes.put(this.oldSpriteProjectiles.get(entityName), (EntityType<? extends EntityProjectileBase>)entityType);
            event.getRegistry().register((IForgeRegistryEntry)entityType);
        }
        for (String entityName : this.oldModelProjectiles.keySet()) {
            registryName = LycanitesMobs.modInfo.modid + ":" + entityName;
            entityTypeBuilder = EntityType.Builder.func_220322_a((EntityType.IFactory)EntityFactory.getInstance(), (EntityClassification)EntityClassification.MISC);
            entityTypeBuilder.setTrackingRange(40);
            entityTypeBuilder.setUpdateInterval(3);
            entityTypeBuilder.setShouldReceiveVelocityUpdates(true);
            entityType = entityTypeBuilder.func_206830_a(entityName);
            entityType.setRegistryName("lycanitesmobs", entityName);
            try {
                EntityFactory.getInstance().addEntityType(entityType, this.oldModelProjectiles.get(entityName).getConstructor(EntityType.class, World.class));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.oldProjectileTypes.put(this.oldModelProjectiles.get(entityName), (EntityType<? extends EntityProjectileBase>)entityType);
            event.getRegistry().register((IForgeRegistryEntry)entityType);
        }
    }

    @Nullable
    public ProjectileInfo getProjectile(String projectileName) {
        if (!this.projectiles.containsKey(projectileName)) {
            return null;
        }
        return this.projectiles.get(projectileName);
    }

    @Nullable
    public EntityType<? extends EntityProjectileBase> getEntityType(String projectileName) {
        ProjectileInfo projectileInfo = this.getProjectile(projectileName);
        if (projectileInfo == null) {
            return null;
        }
        return projectileInfo.getEntityType();
    }

    public void loadOldProjectiles() {
        this.addOldProjectile("summoningportal", EntityPortal.class);
        this.addOldProjectile("frostweb", EntityFrostweb.class, true, true);
        this.addOldProjectile("tundra", EntityTundra.class, true, true);
        this.addOldProjectile("icefireball", EntityIcefireball.class, true, true);
        this.addOldProjectile("blizzard", EntityBlizzard.class, true, true);
        this.addOldProjectile("hellfireball", EntityHellfireball.class, true, true);
        this.addOldProjectile("doomfireball", EntityDoomfireball.class, true, true);
        this.addOldProjectile("devilstar", EntityDevilstar.class, true, true);
        this.addOldProjectile("demonicspark", EntityDemonicSpark.class, false);
        this.addOldProjectile("demonicblast", EntityDemonicBlast.class, true, true);
        this.addOldProjectile("hellfirewall", EntityHellfireWall.class, false);
        this.addOldProjectile("hellfireorb", EntityHellfireOrb.class, false);
        this.addOldProjectile("hellfirewave", EntityHellfireWave.class, false);
        this.addOldProjectile("hellfirewavepart", EntityHellfireWavePart.class, false);
        this.addOldProjectile("hellfirebarrier", EntityHellfireBarrier.class, false);
        this.addOldProjectile("hellfirebarrierpart", EntityHellfireBarrierPart.class, false);
        this.addOldProjectile("devilgatling", EntityDevilGatling.class, false);
        this.addOldProjectile("hellshield", EntityHellShield.class, false);
        this.addOldProjectile("helllaser", EntityHellLaser.class, false);
        this.addOldProjectile("helllaserend", EntityHellLaserEnd.class, false);
        this.addOldProjectile("throwingscythe", EntityThrowingScythe.class, true, true);
        this.addOldProjectile("mudshot", EntityMudshot.class, true, true);
        this.addOldProjectile("aquapulse", EntityAquaPulse.class, true, true);
        this.addOldProjectile("whirlwind", EntityWhirlwind.class, true, true);
        this.addOldProjectile("chaosorb", EntityChaosOrb.class, true, true, true);
        this.addOldProjectile("acidsplash", EntityAcidSplash.class, true, true, true);
        this.addOldProjectile("lightball", EntityLightBall.class, true, true);
        this.addOldProjectile("lifedrain", EntityLifeDrain.class, true, true);
        this.addOldProjectile("lifedrainend", EntityLifeDrainEnd.class, false);
        this.addOldProjectile("crystalshard", EntityCrystalShard.class, true, true);
        this.addOldProjectile("frostbolt", EntityFrostbolt.class, true, true);
        this.addOldProjectile("faebolt", EntityFaeBolt.class, true, true);
        this.addOldProjectile("aetherwave", EntityAetherwave.class, true, true);
        this.addOldProjectile("waterjet", EntityWaterJet.class, true, true);
        this.addOldProjectile("waterjetend", EntityWaterJetEnd.class, false);
        this.addOldProjectile("magma", EntityMagma.class, true, true);
        this.addOldProjectile("scorchfireball", EntityScorchfireball.class, true, true);
        this.addOldProjectile("poop", EntityPoop.class, true, true);
        this.addOldProjectile("boulderblast", EntityBoulderBlast.class, true, true);
        this.addOldProjectile("arcanelaserstorm", EntityArcaneLaserStorm.class, true, true);
        this.addOldProjectile("arcanelaser", EntityArcaneLaser.class, false);
        this.addOldProjectile("arcanelaserend", EntityArcaneLaserEnd.class, false);
        this.addOldProjectile("quill", EntityQuill.class, true, true);
        this.addOldProjectile("spectralbolt", EntitySpectralbolt.class, true, true);
        this.addOldProjectile("bloodleech", EntityBloodleech.class, true, true);
        this.addOldProjectile("poisonray", EntityPoisonRay.class, true, true);
        this.addOldProjectile("poisonrayend", EntityPoisonRayEnd.class, false);
    }

    public void addOldProjectile(String name, Class<? extends EntityProjectileBase> entityClass) {
        if (EntityProjectileModel.class.isAssignableFrom(entityClass)) {
            this.oldModelProjectiles.put(name, entityClass);
            return;
        }
        this.oldSpriteProjectiles.put(name, entityClass);
    }

    public void addOldProjectile(String name, Class<? extends EntityProjectileBase> entityClass, boolean impactSound) {
        ModInfo modInfo = LycanitesMobs.modInfo;
        ObjectManager.addSound(name, modInfo, "projectile." + name);
        if (impactSound) {
            ObjectManager.addSound(name + "_impact", modInfo, "projectile." + name + ".impact");
        }
        this.addOldProjectile(name, entityClass);
    }

    public void addOldProjectile(String name, Class<? extends EntityProjectileBase> entityClass, boolean createChargeItem, boolean createDispenserBehaviour) {
        this.addOldProjectile(name, entityClass, createChargeItem, createDispenserBehaviour, false);
    }

    public void addOldProjectile(String name, Class<? extends EntityProjectileBase> entityClass, boolean createChargeItem, boolean createDispenserBehaviour, boolean impactSound) {
        this.addOldProjectile(name, entityClass, impactSound);
        if (createChargeItem) {
            Item.Properties itemProperties = new Item.Properties().func_200916_a(ItemManager.getInstance().items);
            ItemCharge chargeItem = new ItemCharge(itemProperties, name + "charge", entityClass);
            ObjectManager.addItem(name + "charge", chargeItem);
            if (createDispenserBehaviour) {
                DispenserBehaviorProjectile dispenserBehaviour = new DispenserBehaviorProjectile(entityClass, name);
                DispenserBlock.func_199774_a((IItemProvider)chargeItem, (IDispenseItemBehavior)dispenserBehaviour);
            }
        }
    }

    public EntityProjectileBase createOldProjectile(Class<? extends EntityProjectileBase> projectileClass, World world, LivingEntity entity) {
        try {
            return projectileClass.getConstructor(EntityType.class, World.class, LivingEntity.class).newInstance(this.oldProjectileTypes.get(projectileClass), world, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public EntityProjectileBase createOldProjectile(Class<? extends EntityProjectileBase> projectileClass, World world, double x, double y, double z) {
        try {
            return projectileClass.getConstructor(EntityType.class, World.class, Double.class, Double.class, Double.class).newInstance(this.oldProjectileTypes.get(projectileClass), world, x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

