/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigCreatureSubspecies;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.model.ModelCreatureBase;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Subspecies {
    public static int BASE_WEIGHT = 400;
    public static Map<String, Integer> COMMON_WEIGHTS = new HashMap<String, Integer>(){
        {
            this.put("common", 100);
            this.put("uncommon", 20);
            this.put("rare", 2);
            this.put("legendary", 1);
        }
    };
    public static String[] SUBSPECIES_NAMES = new String[]{"uncommon", "rare"};
    public static Map<String, Double> statMultipliers = new HashMap<String, Double>();
    public static int uncommonDropScale = 2;
    public static int rareDropScale = 5;
    public static double uncommonExperienceScale = 2.0;
    public static double rareExperienceScale = 10.0;
    public static int uncommonSpawnDayMin = 0;
    public static int rareSpawnDayMin = 0;
    public static boolean rareHealthBars = false;
    public int index;
    public double scale = 1.0;
    public String skin;
    public String color;
    public String rarity;
    @OnlyIn(value=Dist.CLIENT)
    public Class<? extends ModelCreatureBase> modelClass;
    public int weight;
    public int priority = 0;
    public List<SpawnCondition> spawnConditions = new ArrayList<SpawnCondition>();

    public static void loadGlobalSettings() {
        BASE_WEIGHT = (Integer)ConfigCreatureSubspecies.INSTANCE.baseWeight.get();
        for (String subspeciesName : SUBSPECIES_NAMES) {
            COMMON_WEIGHTS.put(subspeciesName, (Integer)ConfigCreatureSubspecies.INSTANCE.commonWeights.get(subspeciesName).get());
        }
        statMultipliers = new HashMap<String, Double>();
        for (String subspeciesName : SUBSPECIES_NAMES) {
            for (String statName : CreatureStats.STAT_NAMES) {
                statMultipliers.put((subspeciesName + "-" + statName).toUpperCase(), (Double)ConfigCreatureSubspecies.INSTANCE.subspeciesMultipliers.get(subspeciesName).get(statName).get());
            }
        }
        uncommonDropScale = (Integer)ConfigCreatureSubspecies.INSTANCE.uncommonDropScale.get();
        rareDropScale = (Integer)ConfigCreatureSubspecies.INSTANCE.rareDropScale.get();
        uncommonExperienceScale = (Double)ConfigCreatureSubspecies.INSTANCE.uncommonExperienceScale.get();
        rareExperienceScale = (Double)ConfigCreatureSubspecies.INSTANCE.rareExperienceScale.get();
        uncommonSpawnDayMin = (Integer)ConfigCreatureSubspecies.INSTANCE.uncommonSpawnDayMin.get();
        rareSpawnDayMin = (Integer)ConfigCreatureSubspecies.INSTANCE.rareSpawnDayMin.get();
        rareHealthBars = (Boolean)ConfigCreatureSubspecies.INSTANCE.rareHealthBars.get();
    }

    public static Subspecies createFromJSON(CreatureInfo creatureInfo, JsonObject json) {
        String rarity = "uncommon";
        if (json.has("rarity")) {
            rarity = json.get("rarity").getAsString().toLowerCase();
        } else if (json.has("type")) {
            rarity = json.get("type").getAsString().toLowerCase();
        }
        String skin = null;
        if (json.has("skin")) {
            skin = json.get("skin").getAsString().toLowerCase();
        }
        String color = null;
        if (json.has("color")) {
            color = json.get("color").getAsString().toLowerCase();
        } else if (json.has("name")) {
            color = json.get("name").getAsString().toLowerCase();
        }
        if (skin == null && color == null) {
            throw new RuntimeException("Invalid subspecies added with no Skin and/or Color defined! At least one value must be set.");
        }
        Subspecies subspecies = new Subspecies(skin, color, rarity);
        subspecies.index = json.get("index").getAsInt();
        if (json.has("scale")) {
            subspecies.scale = json.get("scale").getAsDouble();
        }
        if (json.has("modelClass")) {
            try {
                ClientManager.getInstance().loadSubspeciesModel(subspecies, json.get("modelClass").getAsString());
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "[Creature] Unable to find a valid Java Model Class: " + json.get("modelClass").getAsString() + " for subspecies: " + subspecies.getTitle() + " entity: " + creatureInfo.getTitle());
            }
        }
        if (json.has("priority")) {
            subspecies.priority = json.get("priority").getAsInt();
        }
        if (json.has("conditions")) {
            JsonArray jsonArray = json.get("conditions").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject conditionJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnCondition spawnCondition = SpawnCondition.createFromJSON(conditionJson);
                subspecies.spawnConditions.add(spawnCondition);
            }
        }
        return subspecies;
    }

    public Subspecies(@Nullable String skin, @Nullable String color, String rarity) {
        this.color = color;
        this.skin = skin;
        this.rarity = rarity;
        this.weight = COMMON_WEIGHTS.get(rarity);
    }

    public void load(CreatureInfo creatureInfo) {
        if (this.skin != null && !creatureInfo.loadedSubspeciesSkins.contains(this.skin)) {
            creatureInfo.addSounds("." + this.skin);
            creatureInfo.loadedSubspeciesSkins.add(this.skin);
        }
    }

    public String getTitle() {
        String subspeciesName = "";
        if (this.color != null) {
            subspeciesName = subspeciesName + LanguageManager.translate("subspecies." + this.color + ".name");
        }
        if (this.skin != null) {
            if (!subspeciesName.equals("")) {
                subspeciesName = subspeciesName + " ";
            }
            subspeciesName = subspeciesName + LanguageManager.translate("subspecies." + this.skin + ".name");
        }
        return subspeciesName;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean canSpawn(LivingEntity entityLiving) {
        if (entityLiving != null) {
            World world = entityLiving.func_130014_f_();
            int day = (int)Math.floor((double)world.func_82737_E() / 23999.0);
            int spawnDayMin = 0;
            if ("uncommon".equalsIgnoreCase(this.rarity)) {
                spawnDayMin = uncommonSpawnDayMin;
            } else if ("rare".equalsIgnoreCase(this.rarity)) {
                spawnDayMin = rareSpawnDayMin;
            }
            if (day < spawnDayMin) {
                return false;
            }
            for (SpawnCondition condition : this.spawnConditions) {
                if (condition.isMet(world, null, entityLiving.func_180425_c())) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String subspeciesName;
        String string = subspeciesName = this.color != null ? this.color : "normal";
        if (this.skin != null) {
            subspeciesName = subspeciesName + " - " + this.skin;
        }
        subspeciesName = subspeciesName + " - " + this.weight;
        return subspeciesName;
    }
}

