/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ToolType;

public class ObjectLists {
    public static String[] itemListNames = new String[]{"RawMeat", "CookedMeat", "Vegetables", "RawFish", "CookedFish", "CactusFood", "Mushrooms", "Sweets", "Fuel"};
    public static Map<String, List<ItemStack>> itemLists = new HashMap<String, List<ItemStack>>();
    public static Map<String, List<EntityType>> entityLists = new HashMap<String, List<EntityType>>();
    public static Map<String, List<Effect>> effectLists = new HashMap<String, List<Effect>>();

    public static void addItem(String list, Object object) {
        if (!(object instanceof Item || object instanceof Block || object instanceof ItemStack || object instanceof String)) {
            return;
        }
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            itemLists.put(list, new ArrayList());
        }
        ItemStack itemStack = null;
        if (object instanceof Item) {
            itemStack = new ItemStack((IItemProvider)((Item)object));
        } else if (object instanceof Block) {
            itemStack = new ItemStack((IItemProvider)((Block)object));
        } else if (object instanceof ItemStack) {
            itemStack = (ItemStack)object;
        } else if (ObjectManager.getItem((String)object) != null) {
            itemStack = new ItemStack((IItemProvider)ObjectManager.getItem((String)object));
        } else if (ObjectManager.getBlock((String)object) != null) {
            itemStack = new ItemStack((IItemProvider)ObjectManager.getBlock((String)object));
        }
        if (itemStack != null) {
            itemLists.get(list).add(itemStack);
        }
    }

    public static void addEntity(String list, Object object) {
        CreatureInfo creatureInfo;
        if (!(object instanceof Entity) && !(object instanceof String)) {
            return;
        }
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            entityLists.put(list, new ArrayList());
        }
        EntityType<? extends LivingEntity> entityType = null;
        if (object instanceof String && (creatureInfo = CreatureManager.getInstance().getCreature((String)object)) != null) {
            entityType = creatureInfo.getEntityType();
        }
        if (entityType != null) {
            entityLists.get(list).add(entityType);
        }
    }

    public static void addEffect(String list, Effect effect) {
        if (effect == null) {
            return;
        }
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            effectLists.put(list, new ArrayList());
        }
        effectLists.get(list).add(effect);
    }

    public static List<ItemStack> getItems(String list) {
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            return new ArrayList<ItemStack>();
        }
        return itemLists.get(list);
    }

    public static List<EntityType> getEntites(String list) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return new ArrayList<EntityType>();
        }
        return entityLists.get(list);
    }

    public static List<Effect> getEffects(String list) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return new ArrayList<Effect>();
        }
        return effectLists.get(list);
    }

    public static boolean inItemList(String list, ItemStack testStack) {
        list = list.toLowerCase();
        if (testStack == null || testStack.func_190926_b()) {
            return false;
        }
        if (!itemLists.containsKey(list)) {
            return false;
        }
        for (ItemStack listStack : itemLists.get(list)) {
            if (testStack.func_77973_b() != listStack.func_77973_b() || testStack.func_77952_i() != listStack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static boolean inEntityList(String list, Class testClass) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return false;
    }

    public static boolean inEffectList(String list, Effect effect) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return effectLists.get(list).contains(effect);
    }

    public static void createCustomItems() {
    }

    public static void createLists() {
        ObjectLists.addItem("rawmeat", Items.field_151082_bd);
        ObjectLists.addItem("rawmeat", Items.field_151147_al);
        ObjectLists.addItem("rawmeat", Items.field_151076_bf);
        ObjectLists.addItem("cookedmeat", Items.field_151083_be);
        ObjectLists.addItem("cookedmeat", Items.field_151157_am);
        ObjectLists.addItem("cookedmeat", Items.field_151077_bg);
        ObjectLists.addItem("vegetables", Items.field_151015_O);
        ObjectLists.addItem("vegetables", Items.field_151172_bF);
        ObjectLists.addItem("vegetables", Items.field_151174_bG);
        ObjectLists.addItem("fruit", Items.field_151034_e);
        ObjectLists.addItem("fruit", Items.field_151127_ba);
        ObjectLists.addItem("fruit", Blocks.field_150423_aK);
        ObjectLists.addItem("fruit", Items.field_151158_bO);
        ObjectLists.addItem("rawfish", Items.field_196086_aW);
        ObjectLists.addItem("rawfish", Items.field_196087_aX);
        ObjectLists.addItem("cookedfish", Items.field_196102_ba);
        ObjectLists.addItem("cookedfish", Items.field_196104_bb);
        ObjectLists.addItem("cactusfood", Items.field_222079_lj);
        ObjectLists.addItem("mushrooms", Items.field_151009_A);
        ObjectLists.addItem("mushrooms", Blocks.field_150337_Q);
        ObjectLists.addItem("mushrooms", Blocks.field_150338_P);
        ObjectLists.addItem("mushrooms", Blocks.field_150337_Q);
        ObjectLists.addItem("mushrooms", Blocks.field_150420_aW);
        ObjectLists.addItem("mushrooms", Blocks.field_150419_aX);
        ObjectLists.addItem("sweets", Items.field_151102_aT);
        ObjectLists.addItem("sweets", Items.field_196130_bo);
        ObjectLists.addItem("sweets", Items.field_151106_aX);
        ObjectLists.addItem("sweets", Blocks.field_150414_aQ);
        ObjectLists.addItem("sweets", Items.field_151158_bO);
        ObjectLists.addItem("fuel", Items.field_151044_h);
        for (String itemListName : itemListNames) {
            ObjectLists.addFromConfig(itemListName.toLowerCase());
        }
    }

    public static void addFromConfig(String listName) {
    }

    public static boolean isSword(Item item) {
        if (item == null) {
            return false;
        }
        if (item instanceof SwordItem) {
            return true;
        }
        if (item instanceof ShearsItem) {
            return false;
        }
        return item.func_150893_a(new ItemStack((IItemProvider)item), Blocks.field_150440_ba.func_176223_P()) > 1.0f;
    }

    public static boolean isPickaxe(Item item) {
        if (item == null) {
            return false;
        }
        try {
            String[] toolNameParts = item.func_77658_a().split("\\.");
            if (toolNameParts.length >= 3 && "InfiTool".equalsIgnoreCase(toolNameParts[1])) {
                String toolName = toolNameParts[2];
                return "Pickaxe".equalsIgnoreCase(toolName) || "Hammer".equalsIgnoreCase(toolName);
            }
            if (item instanceof PickaxeItem) {
                return true;
            }
            if (item.getHarvestLevel(new ItemStack((IItemProvider)item), ToolType.PICKAXE, null, null) != -1) {
                return true;
            }
            return item.func_150893_a(new ItemStack((IItemProvider)item), Blocks.field_150348_b.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAxe(Item item) {
        if (item == null) {
            return false;
        }
        try {
            String[] toolNameParts;
            for (String toolNamePart : toolNameParts = item.func_77658_a().split("\\.")) {
                if (toolNameParts.length < 3 || !"InfiTool".equalsIgnoreCase(toolNameParts[1])) continue;
                String toolName = toolNameParts[2];
                return "Axe".equalsIgnoreCase(toolName) || "LumberAxe".equalsIgnoreCase(toolName) || "Mattock".equalsIgnoreCase(toolName) || "Battleaxe".equalsIgnoreCase(toolName);
            }
            if (item instanceof AxeItem) {
                return true;
            }
            if (item.getHarvestLevel(new ItemStack((IItemProvider)item), ToolType.AXE, null, null) != -1) {
                return true;
            }
            return item.func_150893_a(new ItemStack((IItemProvider)item), Blocks.field_196617_K.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isShovel(Item item) {
        if (item == null) {
            return false;
        }
        try {
            String[] toolNameParts = item.func_77658_a().split("\\.");
            if (toolNameParts.length >= 3 && "InfiTool".equalsIgnoreCase(toolNameParts[1])) {
                String toolName = toolNameParts[2];
                return "Shovel".equalsIgnoreCase(toolName) || "Excavator".equalsIgnoreCase(toolName) || "Mattock".equalsIgnoreCase(toolName);
            }
            if (item instanceof ShovelItem) {
                return true;
            }
            if (item.getHarvestLevel(new ItemStack((IItemProvider)item), ToolType.SHOVEL, null, null) != -1) {
                return true;
            }
            return item.func_150893_a(new ItemStack((IItemProvider)item), Blocks.field_150346_d.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isName(Item item, String name) {
        if (item == null) {
            return false;
        }
        String itemName = item.func_77658_a().toLowerCase();
        return itemName.contains(name);
    }

    public static boolean isName(Block block, String name) {
        if (block == null) {
            return false;
        }
        name = name.toLowerCase();
        String blockName = block.func_149739_a().toLowerCase();
        return blockName.contains(name);
    }
}

