/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.model.ModelItemBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ItemInfo {
    protected String name;
    public Class<? extends Item> itemClass;
    public Class<? extends ModelItemBase> modelClass;
    public ModInfo group;

    public ItemInfo(ModInfo group) {
        this.group = group;
    }

    public void loadFromJSON(JsonObject json) {
        this.name = json.get("name").getAsString();
        try {
            this.itemClass = Class.forName(json.get("itemClass").getAsString());
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "[Projectile] Unable to find the Java Item Class: " + json.get("itemClass").getAsString() + " for " + this.getName());
        }
        try {
            this.modelClass = Class.forName(json.get("modelClass").getAsString());
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "[Projectile] Unable to find the Java Model Class: " + json.get("modelClass").getAsString() + " for " + this.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEntityId() {
        return this.group.modid + ":" + this.getName();
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.group.modid, this.getName());
    }

    public String getLocalisationKey() {
        return this.group.modid + "." + this.getName();
    }

    public String getTitle() {
        return LanguageManager.translate("item." + this.getLocalisationKey() + ".name");
    }

    public String getDescription() {
        return LanguageManager.translate("item." + this.getLocalisationKey() + ".description");
    }
}

