/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ElementInfo {
    public String name = "default";
    protected List<String> componentNames = new ArrayList<String>();
    public List<ElementInfo> components = new ArrayList<ElementInfo>();
    public String type;
    public List<String> buffs = new ArrayList<String>();
    public List<String> debuffs = new ArrayList<String>();
    public List<String> immunities = new ArrayList<String>();
    public double buffDurationMultiplier = 1.0;
    public double debuffDurationMultiplier = 1.0;
    public boolean canBurn = true;
    public boolean canFreeze = true;

    public void loadFromJSON(JsonObject json) {
        if (json.has("name")) {
            this.name = json.get("name").getAsString();
        }
        if (json.has("components")) {
            this.componentNames = JSONHelper.getJsonStrings(json.get("components").getAsJsonArray());
        }
        if (json.has("type")) {
            this.type = json.get("type").getAsString();
        } else {
            String string = this.type = this.componentNames.isEmpty() ? "primal" : "compound";
        }
        if (json.has("buffs")) {
            this.buffs = JSONHelper.getJsonStrings(json.get("buffs").getAsJsonArray());
        }
        if (json.has("debuffs")) {
            this.debuffs = JSONHelper.getJsonStrings(json.get("debuffs").getAsJsonArray());
        }
        if (json.has("immunities")) {
            this.immunities = JSONHelper.getJsonStrings(json.get("immunities").getAsJsonArray());
        }
        if (json.has("buffDurationMultiplier")) {
            this.buffDurationMultiplier = json.get("buffDurationMultiplier").getAsDouble();
        }
        if (json.has("debuffDurationMultiplier")) {
            this.debuffDurationMultiplier = json.get("debuffDurationMultiplier").getAsDouble();
        }
        if (json.has("canBurn")) {
            this.canBurn = json.get("canBurn").getAsBoolean();
        }
        if (json.has("canFreeze")) {
            this.canFreeze = json.get("canFreeze").getAsBoolean();
        }
    }

    public void init() {
        if (this.type.equalsIgnoreCase("compound")) {
            for (String componentName : this.componentNames) {
                if (!ElementManager.getInstance().elements.containsKey(componentName)) continue;
                this.components.add(ElementManager.getInstance().elements.get(componentName));
            }
        }
    }

    public String getTitle() {
        return LanguageManager.translate("element." + this.name + ".name");
    }

    public String getDescription() {
        return LanguageManager.translate("element." + this.name + ".description");
    }

    public void buffEntity(LivingEntity targetEntity, int duration, int amplifier) {
        if (duration <= 0 || amplifier < 0) {
            return;
        }
        duration = Math.round((float)duration * (float)this.buffDurationMultiplier);
        for (String buff : this.buffs) {
            Effect effect = (Effect)GameRegistry.findRegistry(Effect.class).getValue(new ResourceLocation(buff));
            if (effect == null) continue;
            targetEntity.func_195064_c(new EffectInstance(effect, duration, amplifier));
        }
    }

    public void debuffEntity(LivingEntity targetEntity, int duration, int amplifier) {
        if (duration <= 0 || amplifier < 0) {
            return;
        }
        duration = Math.round((float)duration * (float)this.debuffDurationMultiplier);
        for (String debuff : this.debuffs) {
            if ("burning".equalsIgnoreCase(debuff)) {
                targetEntity.func_70015_d(duration / 20);
                continue;
            }
            Effect effect = (Effect)GameRegistry.findRegistry(Effect.class).getValue(new ResourceLocation(debuff));
            if (effect == null) continue;
            targetEntity.func_195064_c(new EffectInstance(effect, duration, amplifier));
        }
    }

    public boolean isEffectApplicable(EffectInstance effect) {
        if (effect == null || effect.func_188419_a() == null || effect.func_188419_a().getRegistryName() == null) {
            return false;
        }
        if (this.debuffs.contains(effect.func_188419_a().getRegistryName().toString())) {
            return false;
        }
        return !this.immunities.contains(effect.func_188419_a().getRegistryName().toString());
    }

    public boolean canBurn() {
        return this.canBurn;
    }

    public boolean canFreeze() {
        return this.canFreeze;
    }
}

