/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.ItemCustomSpawnEgg;
import com.lycanitesmobs.core.item.consumable.ItemTreat;
import com.lycanitesmobs.core.item.special.ItemSoulstone;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;

public class CreatureType {
    protected String name;
    public ModInfo modInfo;
    public Map<String, CreatureInfo> creatures = new HashMap<String, CreatureInfo>();
    public List<CreatureInfo> tameableCreatures = new ArrayList<CreatureInfo>();
    public Item treat;
    public ItemSoulstone soulstone;
    public Item spawnEgg;

    public CreatureType(ModInfo group) {
        this.modInfo = group;
    }

    public void loadFromJSON(JsonObject json) {
        this.name = json.get("name").getAsString();
    }

    public void load() {
        this.createItems();
        LycanitesMobs.logDebug("Creature Type", "Loaded Creature Type: " + this.getTitle());
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return LanguageManager.translate("creaturetype." + this.getName() + ".name");
    }

    public String getTreatName() {
        return this.getName() + "treat";
    }

    public String getSpawnEggName() {
        return this.getName() + "spawn";
    }

    public Item getTreatItem() {
        return this.treat;
    }

    public void addCreature(CreatureInfo creatureInfo) {
        if (this.creatures.containsKey(creatureInfo.getName())) {
            return;
        }
        this.creatures.put(creatureInfo.getName(), creatureInfo);
        if (creatureInfo.isTameable()) {
            this.tameableCreatures.add(creatureInfo);
        }
    }

    public void createItems() {
        this.treat = ObjectManager.getItem(this.getTreatName());
        if (this.treat != null) {
            return;
        }
        Item.Properties treatProperties = new Item.Properties();
        treatProperties.func_200917_a(16);
        this.treat = new ItemTreat(treatProperties, this);
        ObjectManager.addItem(this.getTreatName(), this.treat);
        String spawnEggName = this.getSpawnEggName();
        Item.Properties spawnEggProperties = new Item.Properties();
        spawnEggProperties.func_200916_a(ItemManager.getInstance().creatures);
        this.spawnEgg = new ItemCustomSpawnEgg(spawnEggProperties, spawnEggName, this);
        ObjectManager.addItem(spawnEggName, this.spawnEgg);
    }
}

