/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.core.config.ConfigCreatureSpawning;
import java.util.ArrayList;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CreatureSpawnConfig {
    public int typeSpawnLimit = 64;
    public double spawnLimitRange = 32.0;
    public boolean disableAllSpawning = false;
    public boolean disableDungeonSpawners = false;
    public boolean enforceBlockCost = true;
    public boolean useSurfaceLightLevel = true;
    public double spawnWeightScale = 1.0;
    public double dungeonSpawnerWeightScale = 1.0;
    public boolean ignoreWorldGenSpawning = false;
    public boolean controlVanillaSpawns = false;
    public int[] dimensionList;
    public boolean dimensionListWhitelist = false;

    public void loadConfig() {
        this.typeSpawnLimit = (Integer)ConfigCreatureSpawning.INSTANCE.typeSpawnLimit.get();
        this.spawnLimitRange = (Double)ConfigCreatureSpawning.INSTANCE.spawnLimitRange.get();
        this.disableAllSpawning = (Boolean)ConfigCreatureSpawning.INSTANCE.disableAllSpawning.get();
        this.enforceBlockCost = (Boolean)ConfigCreatureSpawning.INSTANCE.enforceBlockCost.get();
        this.spawnWeightScale = (Double)ConfigCreatureSpawning.INSTANCE.spawnWeightScale.get();
        this.useSurfaceLightLevel = (Boolean)ConfigCreatureSpawning.INSTANCE.useSurfaceLightLevel.get();
        this.ignoreWorldGenSpawning = (Boolean)ConfigCreatureSpawning.INSTANCE.ignoreWorldGenSpawning.get();
        this.controlVanillaSpawns = (Boolean)ConfigCreatureSpawning.INSTANCE.controlVanillaSpawns.get();
        String dimensionListValue = (String)ConfigCreatureSpawning.INSTANCE.globalDimensionList.get();
        ArrayList<Integer> dimensionEntries = new ArrayList<Integer>();
        for (String dimensionEntry : dimensionListValue.replace(" ", "").split(",")) {
            if (!NumberUtils.isCreatable((String)dimensionEntry)) continue;
            dimensionEntries.add(Integer.parseInt(dimensionEntry));
        }
        this.dimensionList = ArrayUtils.toPrimitive((Integer[])dimensionEntries.toArray(new Integer[dimensionEntries.size()]));
        this.dimensionListWhitelist = (Boolean)ConfigCreatureSpawning.INSTANCE.globalDimensionWhitelist.get();
        this.disableDungeonSpawners = (Boolean)ConfigCreatureSpawning.INSTANCE.disableDungeonSpawners.get();
        this.dungeonSpawnerWeightScale = (Double)ConfigCreatureSpawning.INSTANCE.dungeonSpawnerWeightScale.get();
    }

    public boolean isAllowedGlobal(World world) {
        if (this.disableAllSpawning) {
            return false;
        }
        if (this.dimensionList.length > 0) {
            boolean inDimensionList = false;
            for (int dimensionId : this.dimensionList) {
                if (dimensionId != world.func_201675_m().func_186058_p().func_186068_a()) continue;
                inDimensionList = true;
                break;
            }
            if (inDimensionList && !this.dimensionListWhitelist) {
                return false;
            }
            if (!inDimensionList && this.dimensionListWhitelist) {
                return false;
            }
        }
        return true;
    }
}

