/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.config.ConfigCreatures;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.CreatureConfig;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureSpawnConfig;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.spawner.SpawnerMobRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CreatureManager
extends JSONLoader {
    public static CreatureManager INSTANCE;
    public static String[] DIFFICULTY_NAMES;
    public static double[] DIFFICULTY_DEFAULTS;
    public CreatureConfig config;
    public CreatureSpawnConfig spawnConfig;
    public Map<String, CreatureType> creatureTypes = new HashMap<String, CreatureType>();
    public Map<String, CreatureInfo> creatures = new HashMap<String, CreatureInfo>();
    public Map<Class, CreatureInfo> creatureClassMap = new HashMap<Class, CreatureInfo>();
    protected int nextCreatureNetworkId = 100;
    public List<ModInfo> loadedMods = new ArrayList<ModInfo>();
    public Map<String, Double> difficultyMultipliers = new HashMap<String, Double>();
    public Map<String, Double> levelMultipliers = new HashMap<String, Double>();
    public double tamedHealthMultiplier = 3.0;
    public boolean dlDungeonsLoaded = false;

    public static CreatureManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreatureManager();
        }
        return INSTANCE;
    }

    public CreatureManager() {
        this.config = new CreatureConfig();
        this.spawnConfig = new CreatureSpawnConfig();
    }

    public void startup(ModInfo modInfo) {
        this.loadCreatureTypesFromJSON(modInfo);
        this.loadCreaturesFromJSON(modInfo);
        for (CreatureType creatureType : this.creatureTypes.values()) {
            creatureType.load();
        }
        for (CreatureInfo creatureInfo : this.creatures.values()) {
            creatureInfo.load();
        }
    }

    public void loadConfig() {
        this.config.loadConfig();
        this.spawnConfig.loadConfig();
        this.difficultyMultipliers = new HashMap<String, Double>();
        for (String difficultyName : DIFFICULTY_NAMES) {
            for (String statName : CreatureStats.STAT_NAMES) {
                this.difficultyMultipliers.put((difficultyName + "-" + statName).toUpperCase(), (Double)ConfigCreatures.INSTANCE.difficultyMultipliers.get(difficultyName).get(statName).get());
            }
        }
        for (String statName : CreatureStats.STAT_NAMES) {
            this.levelMultipliers.put(statName.toUpperCase(), (Double)ConfigCreatures.INSTANCE.levelMultipliers.get(statName).get());
        }
    }

    public void loadCreatureTypesFromJSON(ModInfo groupInfo) {
        this.loadAllJson(groupInfo, "Creature Type", "creaturetypes", "name", true, null, FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Creature", "Complete! " + this.creatures.size() + " JSON Creature Info Loaded In Total.");
    }

    public void loadCreaturesFromJSON(ModInfo groupInfo) {
        try {
            if (!this.loadedMods.contains(groupInfo)) {
                this.loadedMods.add(groupInfo);
            }
            this.loadAllJson(groupInfo, "Creature", "creatures", "name", true, null, FileLoader.COMMON, StreamLoader.COMMON);
            LycanitesMobs.logDebug("Creature", "Complete! " + this.creatures.size() + " JSON Creature Info Loaded In Total.");
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "No Creatures loaded for: " + groupInfo.name);
        }
    }

    @Override
    public void parseJson(ModInfo groupInfo, String name, JsonObject json) {
        if ("Creature Type".equals(name)) {
            CreatureType creatureType = new CreatureType(groupInfo);
            creatureType.loadFromJSON(json);
            if (creatureType.name == null) {
                LycanitesMobs.logWarning("", "[Creature] Unable to load " + name + " json due to missing name.");
                return;
            }
            if (this.creatureTypes.containsKey(creatureType.name)) {
                creatureType = this.creatureTypes.get(creatureType.name);
                creatureType.loadFromJSON(json);
            }
            this.creatureTypes.put(creatureType.name, creatureType);
            return;
        }
        if ("Creature".equals(name)) {
            CreatureInfo creatureInfo = new CreatureInfo(groupInfo);
            creatureInfo.loadFromJSON(json);
            if (creatureInfo.name == null) {
                LycanitesMobs.logWarning("", "[Creature] Unable to load " + name + " json due to missing name.");
                return;
            }
            if (this.creatures.containsKey(creatureInfo.name)) {
                creatureInfo = this.creatures.get(creatureInfo.name);
                creatureInfo.loadFromJSON(json);
            }
            this.creatures.put(creatureInfo.name, creatureInfo);
            this.creatureClassMap.put(creatureInfo.entityClass, creatureInfo);
        }
    }

    public int getNextCreatureNetworkId() {
        return this.nextCreatureNetworkId++;
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        LycanitesMobs.logDebug("Creature", "Forge registering all " + this.creatures.size() + " creatures...");
        for (CreatureInfo creatureInfo : this.creatures.values()) {
            event.getRegistry().register(creatureInfo.getEntityType());
        }
    }

    public void reload() {
        this.loadConfig();
        SpawnerMobRegistry.SPAWNER_MOB_REGISTRIES.clear();
        for (ModInfo group : this.loadedMods) {
            this.loadCreaturesFromJSON(group);
        }
    }

    public CreatureType getCreatureType(String creatureTypeName) {
        if (!this.creatureTypes.containsKey(creatureTypeName)) {
            return null;
        }
        return this.creatureTypes.get(creatureTypeName);
    }

    @Nullable
    public CreatureInfo getCreature(String creatureName) {
        if (!this.creatures.containsKey(creatureName)) {
            return null;
        }
        return this.creatures.get(creatureName);
    }

    @Nullable
    public EntityType<? extends LivingEntity> getEntityType(String creatureName) {
        CreatureInfo creatureInfo = this.getCreature(creatureName);
        if (creatureInfo == null) {
            return null;
        }
        return creatureInfo.getEntityType();
    }

    public CreatureInfo getCreature(Class creatureClass) {
        if (!this.creatureClassMap.containsKey(creatureClass)) {
            return null;
        }
        return this.creatureClassMap.get(creatureClass);
    }

    public CreatureInfo getCreatureFromId(String entityId) {
        entityId = entityId.replace(".", ":");
        String[] mobIdParts = entityId.toLowerCase().split(":");
        return this.getCreature(mobIdParts[mobIdParts.length - 1]);
    }

    public double getDifficultyMultiplier(String difficultyName, String statName) {
        String key = difficultyName.toUpperCase() + "-" + statName.toUpperCase();
        if (!this.difficultyMultipliers.containsKey(key)) {
            return 1.0;
        }
        return this.difficultyMultipliers.get(key);
    }

    public double getLevelMultiplier(String statName) {
        if (!this.levelMultipliers.containsKey(statName.toUpperCase())) {
            return 1.0;
        }
        return this.levelMultipliers.get(statName.toUpperCase());
    }

    static {
        DIFFICULTY_NAMES = new String[]{"easy", "normal", "hard"};
        DIFFICULTY_DEFAULTS = new double[]{0.8, 1.0, 1.1};
    }
}

