/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityFactory;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureSpawn;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.ItemDrop;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.model.ModelCreatureBase;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CreatureInfo {
    protected String name;
    public Class<? extends EntityCreatureBase> entityClass;
    public Constructor<? extends EntityCreatureBase> entityConstructor;
    @OnlyIn(value=Dist.CLIENT)
    public Class<? extends ModelCreatureBase> modelClass;
    public ModInfo modInfo;
    public CreatureType creatureType;
    protected EntityType<? extends LivingEntity> entityType;
    public boolean enabled = true;
    public boolean dummy = false;
    public CreatureSpawn creatureSpawn;
    public double width = 0.8;
    public double height = 1.8;
    public int experience = 5;
    public double health = 20.0;
    public double defense = 0.0;
    public double armor = 0.0;
    public double speed = 24.0;
    public double damage = 2.0;
    public double attackSpeed = 1.0;
    public double rangedSpeed = 0.5;
    public double effectDuration = 1.0;
    public double effectAmplifier = -1.0;
    public double pierce = 1.0;
    public double sight = 16.0;
    public double knockbackResistance = 0.0;
    public int eggBackColor;
    public int eggForeColor;
    public boolean boss = false;
    public Map<Integer, Subspecies> subspecies = new HashMap<Integer, Subspecies>();
    public List<String> loadedSubspeciesSkins = new ArrayList<String>();
    public List<ElementInfo> elements = new ArrayList<ElementInfo>();
    public boolean peaceful = false;
    public boolean summonable = false;
    public boolean tameable = false;
    public boolean mountable = false;
    public int summonCost = 1;
    public int dungeonLevel = -1;
    public List<ItemDrop> drops = new ArrayList<ItemDrop>();
    protected JsonArray dropsJson;
    public double sizeScale = 1.0;
    public double hitboxScale = 1.0;

    public CreatureInfo(ModInfo modInfo) {
        this.modInfo = modInfo;
        this.creatureSpawn = new CreatureSpawn();
    }

    public void loadFromJSON(JsonObject json) {
        this.name = json.get("name").getAsString();
        try {
            this.entityClass = Class.forName(json.get("entityClass").getAsString());
            this.entityConstructor = this.entityClass.getConstructor(EntityType.class, World.class);
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "[Creature] Unable to find the Java Entity Class: " + json.get("entityClass").getAsString() + " for " + this.getName());
            throw new RuntimeException(e);
        }
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("dummy")) {
            this.dummy = json.get("dummy").getAsBoolean();
        }
        if (this.dummy) {
            return;
        }
        try {
            ClientManager.getInstance().loadCreatureModel(this, json.get("modelClass").getAsString());
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "[Creature] Unable to find a valid Java Model Class: " + json.get("modelClass").getAsString() + " for creature: " + this.getTitle());
        }
        if (json.has("creatureType")) {
            this.creatureType = CreatureManager.getInstance().getCreatureType(json.get("creatureType").getAsString());
            if (this.creatureType == null) {
                LycanitesMobs.logWarning("", "Unable to find the creature type: " + json.get("creatureType").getAsString() + " when load creature: " + this.name);
            }
        }
        if (this.creatureType == null) {
            this.creatureType = CreatureManager.getInstance().getCreatureType("beast");
        }
        if (this.creatureType != null) {
            this.creatureType.addCreature(this);
        }
        this.creatureSpawn.loadFromJSON(this, json.get("spawning").getAsJsonObject());
        if (json.has("width")) {
            this.width = json.get("width").getAsDouble();
        }
        if (json.has("height")) {
            this.height = json.get("height").getAsDouble();
        }
        if (json.has("sizeScale")) {
            this.sizeScale = json.get("sizeScale").getAsDouble();
        }
        if (json.has("hitboxScale")) {
            this.hitboxScale = json.get("hitboxScale").getAsDouble();
        }
        if (json.has("experience")) {
            this.experience = json.get("experience").getAsInt();
        }
        if (json.has("health")) {
            this.health = json.get("health").getAsDouble();
        }
        if (json.has("defense")) {
            this.defense = json.get("defense").getAsDouble();
        }
        if (json.has("armor")) {
            this.armor = json.get("armor").getAsDouble();
        }
        if (json.has("speed")) {
            this.speed = json.get("speed").getAsDouble();
        }
        if (json.has("damage")) {
            this.damage = json.get("damage").getAsDouble();
        }
        if (json.has("attackSpeed")) {
            this.attackSpeed = json.get("attackSpeed").getAsDouble();
        }
        if (json.has("rangedSpeed")) {
            this.rangedSpeed = json.get("rangedSpeed").getAsDouble();
        }
        if (json.has("effectDuration")) {
            this.effectDuration = json.get("effectDuration").getAsDouble();
        }
        if (json.has("effectAmplifier")) {
            this.effectAmplifier = json.get("effectAmplifier").getAsDouble();
        }
        if (json.has("pierce")) {
            this.pierce = json.get("pierce").getAsDouble();
        }
        if (json.has("knockbackResistance")) {
            this.knockbackResistance = json.get("knockbackResistance").getAsDouble();
        }
        if (json.has("sight")) {
            this.sight = json.get("sight").getAsDouble();
        }
        this.eggBackColor = Color.decode(json.get("eggBackColor").getAsString()).getRGB();
        this.eggForeColor = Color.decode(json.get("eggForeColor").getAsString()).getRGB();
        if (json.has("subspecies")) {
            Iterator subspeciesEntries = json.get("subspecies").getAsJsonArray().iterator();
            while (subspeciesEntries.hasNext()) {
                JsonObject jsonObject = ((JsonElement)subspeciesEntries.next()).getAsJsonObject();
                Subspecies subspecies = Subspecies.createFromJSON(this, jsonObject);
                this.subspecies.put(subspecies.index, subspecies);
            }
        }
        List<String> elementNames = new ArrayList<String>();
        if (json.has("element")) {
            elementNames.add(json.get("element").getAsString());
        }
        if (json.has("elements")) {
            elementNames = JSONHelper.getJsonStrings(json.get("elements").getAsJsonArray());
        }
        this.elements.clear();
        for (String elementName : elementNames) {
            ElementInfo element = ElementManager.getInstance().getElement(elementName);
            if (element == null) {
                throw new RuntimeException("[Creature] The element " + elementName + " cannot be found for: " + this.getName());
            }
            this.elements.add(element);
        }
        if (json.has("boss")) {
            this.boss = json.get("boss").getAsBoolean();
        }
        if (json.has("peaceful")) {
            this.peaceful = json.get("peaceful").getAsBoolean();
        }
        if (json.has("summonable")) {
            this.summonable = json.get("summonable").getAsBoolean();
        }
        if (json.has("tameable")) {
            this.tameable = json.get("tameable").getAsBoolean();
        }
        if (json.has("mountable")) {
            this.mountable = json.get("mountable").getAsBoolean();
        }
        if (json.has("summonCost")) {
            this.summonCost = json.get("summonCost").getAsInt();
        }
        if (json.has("dungeonLevel")) {
            this.dungeonLevel = json.get("dungeonLevel").getAsInt();
        }
        if (json.has("drops")) {
            for (JsonElement mobDropJson : json.getAsJsonArray("drops")) {
                ItemDrop itemDrop = ItemDrop.createFromJSON(mobDropJson.getAsJsonObject());
                if (itemDrop != null) {
                    this.drops.add(itemDrop);
                    continue;
                }
                LycanitesMobs.logWarning("", "[Creature] Unable to add item drop to creature: " + this.name + ".");
            }
        }
    }

    public void load() {
        if (this.dummy) {
            return;
        }
        this.addSounds("");
        for (Subspecies subspecies : this.subspecies.values()) {
            subspecies.load(this);
        }
        this.creatureSpawn.registerVanillaSpawns(this);
        LycanitesMobs.logDebug("Creature", "Creature Loaded: " + this.getName() + " - " + this.entityClass + " (" + this.modInfo.name + ")");
    }

    public void addSounds(String suffix) {
        ObjectManager.addSound(this.name + suffix + "_say", this.modInfo, "entity." + this.name + suffix + ".say");
        ObjectManager.addSound(this.name + suffix + "_hurt", this.modInfo, "entity." + this.name + suffix + ".hurt");
        ObjectManager.addSound(this.name + suffix + "_death", this.modInfo, "entity." + this.name + suffix + ".death");
        ObjectManager.addSound(this.name + suffix + "_step", this.modInfo, "entity." + this.name + suffix + ".step");
        ObjectManager.addSound(this.name + suffix + "_attack", this.modInfo, "entity." + this.name + suffix + ".attack");
        ObjectManager.addSound(this.name + suffix + "_jump", this.modInfo, "entity." + this.name + suffix + ".jump");
        ObjectManager.addSound(this.name + suffix + "_fly", this.modInfo, "entity." + this.name + suffix + ".fly");
        if (this.isSummonable() || this.isTameable() || EntityCreatureTameable.class.isAssignableFrom(this.entityClass)) {
            ObjectManager.addSound(this.name + suffix + "_tame", this.modInfo, "entity." + this.name + suffix + ".tame");
            ObjectManager.addSound(this.name + suffix + "_beg", this.modInfo, "entity." + this.name + suffix + ".beg");
        }
        if (this.isTameable()) {
            ObjectManager.addSound(this.name + suffix + "_eat", this.modInfo, "entity." + this.name + suffix + ".eat");
        }
        if (this.isMountable()) {
            ObjectManager.addSound(this.name + suffix + "_mount", this.modInfo, "entity." + this.name + suffix + ".mount");
        }
        if (this.isBoss()) {
            ObjectManager.addSound(this.name + suffix + "_phase", this.modInfo, "entity." + this.name + suffix + ".phase");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEntityId() {
        return this.modInfo.modid + ":" + this.getName();
    }

    @Nonnull
    public EntityType<? extends LivingEntity> getEntityType() {
        if (this.entityType == null) {
            EntityType.Builder entityTypeBuilder = EntityType.Builder.func_220322_a((EntityType.IFactory)EntityFactory.getInstance(), (EntityClassification)(this.peaceful ? EntityClassification.CREATURE : EntityClassification.MONSTER));
            entityTypeBuilder.setTrackingRange(this.isBoss() ? 32 : 10);
            entityTypeBuilder.setUpdateInterval(3);
            entityTypeBuilder.setShouldReceiveVelocityUpdates(false);
            entityTypeBuilder.func_220321_a((float)this.width, (float)this.height);
            this.entityType = entityTypeBuilder.func_206830_a(this.getName());
            this.entityType.setRegistryName(this.modInfo.modid, this.getName());
            EntityFactory.getInstance().addEntityType(this.entityType, this.entityConstructor);
        }
        return this.entityType;
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.modInfo.modid, this.getName());
    }

    public String getLocalisationKey() {
        return this.modInfo.modid + "." + this.getName();
    }

    public String getTitle() {
        return LanguageManager.translate("entity." + this.getLocalisationKey() + ".name");
    }

    public String getDescription() {
        return LanguageManager.translate("entity." + this.getLocalisationKey() + ".description");
    }

    public String getHabitatDescription() {
        return LanguageManager.translate("entity." + this.getLocalisationKey() + ".habitat");
    }

    public String getCombatDescription() {
        return LanguageManager.translate("entity." + this.getLocalisationKey() + ".combat");
    }

    public ResourceLocation getIcon() {
        ResourceLocation texture = AssetManager.getTexture(this.getName() + "_icon");
        if (texture == null) {
            AssetManager.addTexture(this.getName() + "_icon", this.modInfo, "textures/guis/" + this.getName() + "_icon.png");
            texture = AssetManager.getTexture(this.getName() + "_icon");
        }
        return texture;
    }

    public String getElementNames() {
        if (this.elements.isEmpty()) {
            return "None";
        }
        String elementNames = "";
        boolean firstElement = true;
        for (ElementInfo element : this.elements) {
            if (!firstElement) {
                elementNames = elementNames + ", ";
            }
            firstElement = false;
            elementNames = elementNames + element.getTitle();
        }
        return elementNames;
    }

    public boolean isSummonable() {
        return this.summonable && EntityCreatureTameable.class.isAssignableFrom(this.entityClass);
    }

    public boolean isTameable() {
        return this.tameable && EntityCreatureTameable.class.isAssignableFrom(this.entityClass);
    }

    public boolean isMountable() {
        return this.mountable && EntityCreatureRideable.class.isAssignableFrom(this.entityClass);
    }

    public boolean isBoss() {
        return this.boss;
    }

    @Nullable
    public Subspecies getSubspecies(int index) {
        if (!this.subspecies.containsKey(index)) {
            return null;
        }
        return this.subspecies.get(index);
    }

    public Subspecies getRandomSubspecies(LivingEntity entity, boolean rare) {
        LycanitesMobs.logDebug("Subspecies", "~0===== Subspecies =====0~");
        LycanitesMobs.logDebug("Subspecies", "Selecting random subspecies for: " + entity);
        if (rare) {
            LycanitesMobs.logDebug("Subspecies", "The conditions have been set to rare increasing the chances of a subspecies being picked.");
        }
        if (this.subspecies.isEmpty()) {
            LycanitesMobs.logDebug("Subspecies", "No species available, will be base species.");
            return null;
        }
        LycanitesMobs.logDebug("Subspecies", "Subspecies Available: " + this.subspecies.size());
        ArrayList<Subspecies> possibleSubspecies = new ArrayList<Subspecies>();
        int highestPriority = 0;
        for (Subspecies subspeciesEntry : this.subspecies.values()) {
            if (!subspeciesEntry.canSpawn(entity)) continue;
            possibleSubspecies.add(subspeciesEntry);
            if (subspeciesEntry.priority <= highestPriority) continue;
            highestPriority = subspeciesEntry.priority;
        }
        if (possibleSubspecies.isEmpty()) {
            LycanitesMobs.logDebug("Subspecies", "No subspecies allowed, will be base species.");
            return null;
        }
        if (highestPriority > 0) {
            for (Subspecies subspeciesEntry : possibleSubspecies.toArray(new Subspecies[possibleSubspecies.size()])) {
                if (subspeciesEntry.priority >= highestPriority) continue;
                possibleSubspecies.remove(subspeciesEntry);
            }
        }
        LycanitesMobs.logDebug("Subspecies", "Subspecies Allowed: " + possibleSubspecies.size() + " Highest Priority: " + highestPriority);
        int baseSpeciesWeightScaled = Subspecies.BASE_WEIGHT;
        if (rare) {
            baseSpeciesWeightScaled = Math.round((float)baseSpeciesWeightScaled / 4.0f);
        }
        if (highestPriority > 0) {
            baseSpeciesWeightScaled = 0;
        }
        int totalWeight = baseSpeciesWeightScaled;
        for (Subspecies subspeciesEntry : possibleSubspecies) {
            totalWeight += subspeciesEntry.weight;
        }
        LycanitesMobs.logDebug("Subspecies", "Total Weight: " + totalWeight);
        int roll = entity.func_70681_au().nextInt(totalWeight) + 1;
        LycanitesMobs.logDebug("Subspecies", "Rolled: " + roll);
        if (roll <= baseSpeciesWeightScaled) {
            LycanitesMobs.logDebug("Subspecies", "Base species selected: " + baseSpeciesWeightScaled);
            return null;
        }
        int checkWeight = baseSpeciesWeightScaled;
        for (Subspecies subspeciesEntry : possibleSubspecies) {
            if (roll > (checkWeight += subspeciesEntry.weight)) continue;
            LycanitesMobs.logDebug("Subspecies", "Subspecies selected: " + subspeciesEntry.toString());
            return subspeciesEntry;
        }
        LycanitesMobs.logWarning("Subspecies", "The roll was higher than the Total Weight, this shouldn't happen.");
        return null;
    }

    public Subspecies getRandomSubspecies(LivingEntity entity) {
        return this.getRandomSubspecies(entity, false);
    }

    public Subspecies getChildSubspecies(LivingEntity entity, int hostSubspeciesIndex, Subspecies partnerSubspecies) {
        int partnerSubspeciesIndex;
        Subspecies hostSubspecies = this.getSubspecies(hostSubspeciesIndex);
        int n = partnerSubspeciesIndex = partnerSubspecies != null ? partnerSubspecies.index : 0;
        if (hostSubspeciesIndex == partnerSubspeciesIndex) {
            return hostSubspecies;
        }
        int hostWeight = hostSubspecies != null ? hostSubspecies.weight : Subspecies.BASE_WEIGHT;
        int partnerWeight = partnerSubspecies != null ? partnerSubspecies.weight : Subspecies.BASE_WEIGHT;
        int roll = entity.func_70681_au().nextInt(hostWeight + partnerWeight);
        if (roll > hostWeight) {
            return partnerSubspecies;
        }
        return hostSubspecies;
    }

    public LivingEntity createEntity(World world) {
        try {
            if (this.entityClass == null) {
                return null;
            }
            return (LivingEntity)this.entityConstructor.newInstance(this.getEntityType(), world);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

