/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui.beastiary.list;

import com.lycanitesmobs.core.gui.GuiListBase;
import com.lycanitesmobs.core.gui.beastiary.GuiBeastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.Subspecies;
import java.util.HashMap;
import java.util.Map;

public class GuiSubspeciesList
extends GuiListBase {
    private GuiBeastiary parentGui;
    private CreatureInfo creature;
    private Map<Integer, Integer> subspeciesList = new HashMap<Integer, Integer>();
    private boolean summoning;

    public GuiSubspeciesList(GuiBeastiary parentGui, boolean summoning, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 24);
        this.parentGui = parentGui;
        this.summoning = summoning;
        this.refreshList();
    }

    @Override
    public void createEntries() {
    }

    public void refreshList() {
        this.subspeciesList.clear();
        this.creature = !this.summoning ? this.parentGui.playerExt.selectedCreature : this.parentGui.playerExt.getSelectedSummonSet().getCreatureInfo();
        if (this.creature == null) {
            return;
        }
        this.subspeciesList.put(0, 0);
        int index = 1;
        for (int subspeciesIndex : this.creature.subspecies.keySet()) {
            Subspecies subspecies;
            if (!this.parentGui.playerExt.getBeastiary().hasKnowledgeRank(this.creature.getName(), 2) || (subspecies = this.creature.subspecies.get(subspeciesIndex)) != null && "rare".equals(subspecies.rarity)) continue;
            this.subspeciesList.put(index++, subspeciesIndex);
        }
    }

    protected int getItemCount() {
        return this.subspeciesList.size();
    }
}

