/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui.beastiary.list;

import com.lycanitesmobs.core.gui.GuiListBase;
import com.lycanitesmobs.core.gui.beastiary.GuiBeastiary;
import com.lycanitesmobs.core.gui.beastiary.list.GuiCreatureFilterList;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.pets.PetEntry;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GuiCreatureList
extends GuiListBase<GuiBeastiary> {
    private Type listType;
    private GuiCreatureFilterList filterList;
    private Map<Integer, CreatureInfo> creatureList = new HashMap<Integer, CreatureInfo>();
    private Map<Integer, PetEntry> petList = new HashMap<Integer, PetEntry>();
    private boolean releaseRefresh;

    public GuiCreatureList(Type listType, GuiBeastiary parentGui, GuiCreatureFilterList filterList, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 24);
        this.listType = listType;
        this.filterList = filterList;
        if (this.filterList != null) {
            this.filterList.addFilteredList(this);
        }
        this.refreshList();
    }

    @Override
    public void createEntries() {
    }

    public void refreshList() {
        block6: {
            int creatureIndex;
            block5: {
                this.creatureList.clear();
                this.petList.clear();
                creatureIndex = 0;
                if (this.listType != Type.KNOWLEDGE && this.listType != Type.SUMMONABLE) break block5;
                ArrayList<String> creatures = new ArrayList<String>(((GuiBeastiary)((Object)this.screen)).playerExt.getBeastiary().creatureKnowledgeList.keySet());
                creatures.sort(Collator.getInstance(new Locale("US")));
                for (String creatureName : creatures) {
                    CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(creatureName.toLowerCase());
                    if (this.listType == Type.SUMMONABLE && !creatureInfo.isSummonable() || creatureInfo == null || this.filterList != null && !this.filterList.canListCreature(creatureInfo, this.listType)) continue;
                    this.creatureList.put(creatureIndex++, creatureInfo);
                }
                break block6;
            }
            if (this.listType != Type.PET && this.listType != Type.MOUNT && this.listType != Type.FAMILIAR) break block6;
            String petType = "pet";
            if (this.listType == Type.MOUNT) {
                petType = "mount";
            } else if (this.listType == Type.FAMILIAR) {
                petType = "familiar";
            }
            ArrayList<PetEntry> creatures = new ArrayList<PetEntry>();
            creatures.addAll(((GuiBeastiary)((Object)this.screen)).playerExt.petManager.getEntryList(petType));
            creatures.sort(Comparator.comparing(PetEntry::getDisplayName));
            for (PetEntry petEntry : creatures) {
                CreatureInfo creatureInfo = petEntry.getCreatureInfo();
                if (creatureInfo == null || this.filterList != null && !this.filterList.canListCreature(creatureInfo, this.listType)) continue;
                this.petList.put(creatureIndex++, petEntry);
            }
        }
    }

    protected int getItemCount() {
        if (this.listType == Type.KNOWLEDGE || this.listType == Type.SUMMONABLE) {
            return this.creatureList.size();
        }
        if (this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) {
            return this.petList.size();
        }
        return 0;
    }

    public void changeType(Type listType) {
        this.listType = listType;
        this.refreshList();
    }

    public static enum Type {
        KNOWLEDGE(0),
        SUMMONABLE(1),
        PET(2),
        MOUNT(3),
        FAMILIAR(4);

        public byte id;

        private Type(byte i) {
            this.id = i;
        }
    }
}

