/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui.beastiary.list;

import com.lycanitesmobs.core.gui.GuiListBase;
import com.lycanitesmobs.core.gui.beastiary.GuiBeastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.localisation.LanguageManager;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiCreatureDescriptionList
extends GuiListBase {
    public CreatureKnowledge creatureKnowledge;

    public GuiCreatureDescriptionList(GuiBeastiary parentGui, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 10800);
    }

    @Override
    public void createEntries() {
    }

    protected int getItemCount() {
        return 1;
    }

    public String getContent() {
        if (this.creatureKnowledge == null) {
            return "";
        }
        CreatureInfo creatureInfo = this.creatureKnowledge.getCreatureInfo();
        if (creatureInfo == null) {
            return "";
        }
        String text = "";
        if (creatureInfo.creatureType != null && creatureInfo.isTameable() && creatureInfo.creatureType.getTreatItem() != null) {
            text = "\u00a7l" + LanguageManager.translate("gui.beastiary.tameable") + ": \u00a7r" + LanguageManager.translate(creatureInfo.creatureType.getTreatItem().func_77658_a() + ".name") + "\n\n";
        }
        if (creatureInfo.creatureType != null && creatureInfo.isSummonable() && creatureInfo.creatureType.getTreatItem() != null) {
            text = "\u00a7l" + LanguageManager.translate("gui.beastiary.summonable") + "\u00a7r\n\n";
        }
        text = text + "\u00a7l" + LanguageManager.translate("gui.beastiary.summary") + ": \u00a7r";
        text = text + "\n" + creatureInfo.getDescription();
        text = text + "\n\n\u00a7l" + LanguageManager.translate("creature.stat.base") + ": \u00a7r";
        if (this.creatureKnowledge.rank >= 2) {
            String statPrefix = "\n" + LanguageManager.translate("creature.stat.base") + " ";
            text = text + "\n" + LanguageManager.translate("creature.stat.health") + ": " + creatureInfo.health;
            text = text + "\n" + LanguageManager.translate("creature.stat.defense") + ": " + creatureInfo.defense;
            text = text + "\n" + LanguageManager.translate("creature.stat.speed") + ": " + creatureInfo.speed;
            text = text + "\n" + LanguageManager.translate("creature.stat.damage") + ": " + creatureInfo.damage;
            text = text + "\n" + LanguageManager.translate("creature.stat.pierce") + ": " + creatureInfo.pierce;
            String effectText = creatureInfo.effectDuration + "s " + creatureInfo.effectAmplifier + "X";
            if (creatureInfo.effectDuration <= 0.0 || creatureInfo.effectAmplifier < 0.0) {
                effectText = LanguageManager.translate("common.none");
            }
            text = text + "\n" + LanguageManager.translate("creature.stat.effect") + ": " + effectText;
        } else {
            text = text + "\n" + LanguageManager.translate("gui.beastiary.unlockedat") + " " + LanguageManager.translate("creature.stat.knowledge") + " " + 2;
        }
        text = text + "\n\n\u00a7l" + LanguageManager.translate("gui.beastiary.combat") + ": \u00a7r";
        text = this.creatureKnowledge.rank >= 2 ? text + "\n" + creatureInfo.getCombatDescription() : text + "\n" + LanguageManager.translate("gui.beastiary.unlockedat") + " " + LanguageManager.translate("creature.stat.knowledge") + " " + 2;
        text = text + "\n\n\u00a7l" + LanguageManager.translate("gui.beastiary.habitat") + ": \u00a7r";
        text = this.creatureKnowledge.rank >= 2 ? text + "\n" + creatureInfo.getHabitatDescription() : text + "\n" + LanguageManager.translate("gui.beastiary.unlockedat") + " " + LanguageManager.translate("creature.stat.knowledge") + " " + 2;
        return text;
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        color2 = color1 = 0x33101010;
        GuiUtils.drawGradientRect((int)0, (int)left, (int)top, (int)right, (int)bottom, (int)color1, (int)color2);
    }
}

