/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui.beastiary;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.gui.ButtonBase;
import com.lycanitesmobs.core.gui.beastiary.GuiBeastiary;
import com.lycanitesmobs.core.gui.beastiary.list.GuiCreatureFilterList;
import com.lycanitesmobs.core.gui.beastiary.list.GuiCreatureList;
import com.lycanitesmobs.core.gui.beastiary.list.GuiPetTypeList;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.pets.PetEntry;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiBeastiaryPets
extends GuiBeastiary {
    public GuiCreatureFilterList petTypeList;
    public GuiCreatureList petList;
    private int petCommandIdStart = 200;
    private int releaseConfirmId = 300;
    private int releaseCancelId = 301;

    public GuiBeastiaryPets(PlayerEntity player) {
        super(player);
        this.playerExt.selectedSubspecies = 0;
    }

    @Override
    public ITextComponent getTitle() {
        if (this.playerExt.selectedPet != null) {
            String title = this.playerExt.selectedPet.getDisplayName();
            if (this.playerExt.selectedPet.releaseEntity) {
                title = LanguageManager.translate("gui.pet.release") + " " + title;
            }
            return new TranslationTextComponent(title, new Object[0]);
        }
        if (this.playerExt.petManager.getEntryList("pet").isEmpty() && this.playerExt.petManager.getEntryList("mount").isEmpty() && this.playerExt.petManager.getEntryList("familiar").isEmpty()) {
            return new TranslationTextComponent(LanguageManager.translate("gui.beastiary.pets.empty.title"), new Object[0]);
        }
        return new TranslationTextComponent(LanguageManager.translate("gui.beastiary.pets"), new Object[0]);
    }

    @Override
    public void initControls() {
        super.initControls();
        int petTypeListHeight = Math.round((float)this.colLeftHeight * 0.225f);
        int petTypeListY = this.colLeftY;
        this.petTypeList = new GuiPetTypeList(this, this.colLeftWidth, petTypeListHeight, petTypeListY, petTypeListY + petTypeListHeight, this.colLeftX);
        int petListHeight = Math.round((float)this.colLeftHeight * 0.7f);
        int petListY = petTypeListY + petTypeListHeight + Math.round((float)this.colLeftHeight * 0.025f);
        this.petList = new GuiCreatureList(GuiCreatureList.Type.PET, this, this.petTypeList, this.colLeftWidth, petListHeight, petListY, petListY + petListHeight, this.colLeftX);
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonMarginX = 10 + Math.max(Math.max(this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.actions")), this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.stance"))), this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.movement")));
        int buttonX = this.colRightX + buttonMarginX;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        ButtonBase button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.ACTIVE.id + this.petCommandIdStart, buttonX, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.active"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.TELEPORT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.teleport"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.PVP.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.pvp"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.RELEASE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.release"), this);
        this.buttons.add(button);
        buttonX = this.colRightX + buttonMarginX;
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.passive"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.defensive"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.assist"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.aggressive"), this);
        this.buttons.add(button);
        buttonX = this.colRightX + buttonMarginX;
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.follow"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.wander"), this);
        this.buttons.add(button);
        button = new ButtonBase(EntityCreatureBase.PET_COMMAND_ID.SIT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.sit"), this);
        this.buttons.add(button);
        buttonX = this.colRightX + Math.round((float)this.colRightWidth / 2.0f) - (buttonWidth + buttonSpacing);
        buttonY = this.colRightY + Math.round((float)this.colRightHeight / 2.0f) - Math.round((float)buttonHeight / 2.0f);
        button = new ButtonBase(this.releaseConfirmId, buttonX, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("common.yes"), this);
        this.buttons.add(button);
        button = new ButtonBase(this.releaseCancelId, (buttonX += buttonSpacing) + buttonWidth, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("common.no"), this);
        this.buttons.add(button);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void updateControls(int mouseX, int mouseY, float partialTicks) {
        boolean empty;
        super.updateControls(mouseX, mouseY, partialTicks);
        boolean bl = empty = this.playerExt.petManager.getEntryList("pet").isEmpty() && this.playerExt.petManager.getEntryList("mount").isEmpty() && this.playerExt.petManager.getEntryList("familiar").isEmpty();
        if (!empty) {
            this.petTypeList.render(mouseX, mouseY, partialTicks);
            this.petList.render(mouseX, mouseY, partialTicks);
        }
        for (Widget buttonWidget : this.buttons) {
            if (!(buttonWidget instanceof ButtonBase)) continue;
            ButtonBase button = (ButtonBase)buttonWidget;
            if (button.buttonId >= this.petCommandIdStart && button.buttonId < this.releaseConfirmId) {
                if (this.playerExt.selectedPet != null && !this.playerExt.selectedPet.releaseEntity) {
                    boolean bl2 = button.visible = !empty;
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.ACTIVE.id + this.petCommandIdStart) {
                        if (!this.playerExt.selectedPet.spawningActive) {
                            button.setMessage(LanguageManager.translate("gui.pet.summon"));
                            continue;
                        }
                        button.setMessage(LanguageManager.translate("gui.pet.dismiss"));
                        continue;
                    }
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.PVP.id + this.petCommandIdStart) {
                        if (this.playerExt.selectedPet.summonSet.getPVP()) {
                            button.setMessage(LanguageManager.translate("gui.pet.pvp") + ": " + LanguageManager.translate("common.yes"));
                            continue;
                        }
                        button.setMessage(LanguageManager.translate("gui.pet.pvp") + ": " + LanguageManager.translate("common.no"));
                        continue;
                    }
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart) {
                        button.active = !this.playerExt.selectedPet.summonSet.passive;
                        continue;
                    }
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getPassive() || this.playerExt.selectedPet.summonSet.getAssist() || this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getPassive() || !this.playerExt.selectedPet.summonSet.getAssist() || this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getPassive() || !this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getSitting() || !this.playerExt.selectedPet.summonSet.getFollowing();
                        continue;
                    }
                    if (button.buttonId == EntityCreatureBase.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart) {
                        button.active = this.playerExt.selectedPet.summonSet.getSitting() || this.playerExt.selectedPet.summonSet.getFollowing();
                        continue;
                    }
                    if (button.buttonId != EntityCreatureBase.PET_COMMAND_ID.SIT.id + this.petCommandIdStart) continue;
                    button.active = !this.playerExt.selectedPet.summonSet.getSitting();
                    continue;
                }
                button.visible = false;
                continue;
            }
            if (button.buttonId != this.releaseConfirmId && button.buttonId != this.releaseCancelId) continue;
            button.visible = this.playerExt.selectedPet != null && this.playerExt.selectedPet.releaseEntity && !empty;
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawForeground(mouseX, mouseY, partialTicks);
        int marginX = 0;
        int nextX = this.colRightX + marginX;
        int nextY = this.colRightY + 20;
        int width = this.colRightWidth - marginX;
        if (this.playerExt.petManager.getEntryList("pet").isEmpty() && this.playerExt.petManager.getEntryList("mount").isEmpty() && this.playerExt.petManager.getEntryList("familiar").isEmpty()) {
            String text = LanguageManager.translate("gui.beastiary.pets.empty.info");
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
            return;
        }
        if (this.playerExt.selectedPet != null) {
            this.renderCreature(this.playerExt.selectedPet.getCreatureInfo(), this.colRightX + marginX / 2 + this.colRightWidth / 2, this.colRightY + Math.round((float)this.colRightHeight / 2.0f), mouseX, mouseY, partialTicks);
        }
        String text = "\u00a7l" + LanguageManager.translate("gui.beastiary.player.spirit") + ": ";
        this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
        int barX = nextX + this.getFontRenderer().func_78256_a(text);
        int spiritMax = Math.round((float)this.playerExt.spiritMax / (float)this.playerExt.spiritCharge);
        int spiritReserved = (int)Math.floor((double)this.playerExt.spiritReserved / (double)this.playerExt.spiritCharge);
        int spiritAvailable = (int)Math.floor((double)this.playerExt.spirit / (double)this.playerExt.spiritCharge);
        float spiritFilling = (float)this.playerExt.spirit / (float)this.playerExt.spiritCharge - (float)spiritAvailable;
        this.drawBar(AssetManager.getTexture("GUIPetSpiritEmpty"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritMax, 10);
        this.drawBar(AssetManager.getTexture("GUIPetSpirit"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritAvailable, 10);
        if (spiritFilling > 0.0f) {
            this.drawTexture(AssetManager.getTexture("GUIPetSpiritFilling"), barX + 9 * spiritAvailable, nextY, 0.0f, spiritFilling, 1.0f, spiritFilling * 9.0f, 9.0f);
        }
        this.drawBar(AssetManager.getTexture("GUIPetSpiritUsed"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritReserved, -10);
        if (this.playerExt.selectedPet != null) {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = "\u00a7l" + LanguageManager.translate("creature.stat.spirit") + ": ";
            this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
            this.drawLevel(this.playerExt.selectedPet.getCreatureInfo(), AssetManager.getTexture("GUIPetLevel"), nextX + this.getFontRenderer().func_78256_a(text), nextY);
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = this.playerExt.selectedPet.respawnTime <= 0 ? "\u00a7l" + LanguageManager.translate("creature.stat.health") + ": " : "\u00a7l" + LanguageManager.translate("creature.stat.respawning") + ": ";
            this.getFontRenderer().func_211126_b(text, (float)nextX, (float)nextY, 0xFFFFFF);
            barX = nextX + this.getFontRenderer().func_78256_a(text);
            int barY = nextY - 1;
            int barWidth = 80;
            int barHeight = 10;
            this.drawTexture(AssetManager.getTexture("GUIPetBarEmpty"), barX, barY, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
            if (this.playerExt.selectedPet.respawnTime <= 0) {
                float healthNormal = this.playerExt.selectedPet.getHealth() / this.playerExt.selectedPet.getMaxHealth();
                this.drawTexture(AssetManager.getTexture("GUIPetBarHealth"), barX, barY, 0.0f, healthNormal, 1.0f, (float)barWidth * healthNormal, barHeight);
            } else {
                float respawnNormal = 1.0f - (float)this.playerExt.selectedPet.respawnTime / (float)this.playerExt.selectedPet.respawnTimeMax;
                this.drawTexture(AssetManager.getTexture("GUIPetBarRespawn"), barX, barY, 0.0f, respawnNormal, 1.0f, (float)barWidth * respawnNormal, barHeight);
            }
        } else {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = LanguageManager.translate("gui.beastiary.pets.select");
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
        }
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        if (this.playerExt.selectedPet != null && !this.playerExt.selectedPet.releaseEntity) {
            this.getFontRenderer().func_211126_b("\u00a7l" + LanguageManager.translate("gui.pet.actions"), (float)this.colRightX, (float)(buttonY + 6), 0xFFFFFF);
            this.getFontRenderer().func_211126_b("\u00a7l" + LanguageManager.translate("gui.pet.stance"), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF);
            this.getFontRenderer().func_211126_b("\u00a7l" + LanguageManager.translate("gui.pet.movement"), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF);
        }
        if (this.playerExt.selectedPet != null && this.playerExt.selectedPet.releaseEntity) {
            text = LanguageManager.translate("gui.pet.release.confirm");
            nextX = this.colRightX;
            nextY = this.colRightY + Math.round((float)this.colRightHeight / 2.0f) - Math.round((float)buttonHeight / 2.0f) - this.getFontRenderer().func_78267_b(text, this.colRightWidth) - 2;
            this.drawSplitString(text, nextX, nextY, this.colRightWidth, 0xFFFFFF, true);
        }
    }

    @Override
    public void actionPerformed(byte buttonId) {
        if (this.playerExt.selectedPet != null && this.playerExt.selectedPet.summonSet != null) {
            PetEntry petEntry = this.playerExt.selectedPet;
            if (buttonId >= this.petCommandIdStart && buttonId < this.releaseConfirmId) {
                int petCommandId = buttonId - this.petCommandIdStart;
                if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.ACTIVE.id) {
                    petEntry.spawningActive = !petEntry.spawningActive;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.TELEPORT.id) {
                    petEntry.teleportEntity = true;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.PVP.id) {
                    petEntry.summonSet.pvp = !petEntry.summonSet.pvp;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.RELEASE.id) {
                    petEntry.releaseEntity = true;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.PASSIVE.id) {
                    petEntry.summonSet.passive = true;
                    petEntry.summonSet.assist = false;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.DEFENSIVE.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = false;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.ASSIST.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = true;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.AGGRESSIVE.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = true;
                    petEntry.summonSet.aggressive = true;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.FOLLOW.id) {
                    petEntry.summonSet.following = true;
                    petEntry.summonSet.sitting = false;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.WANDER.id) {
                    petEntry.summonSet.following = false;
                    petEntry.summonSet.sitting = false;
                } else if (petCommandId == EntityCreatureBase.PET_COMMAND_ID.SIT.id) {
                    petEntry.summonSet.following = false;
                    petEntry.summonSet.sitting = true;
                }
                this.playerExt.sendPetEntryToServer(petEntry);
                if (this.playerExt.selectedPet == null) {
                    this.mc.func_147108_a((Screen)new GuiBeastiaryPets((PlayerEntity)this.mc.field_71439_g));
                }
                return;
            }
            if (buttonId == this.releaseCancelId) {
                petEntry.releaseEntity = false;
                return;
            }
            if (buttonId == this.releaseConfirmId) {
                this.playerExt.selectedPet = null;
                this.playerExt.sendPetEntryRemoveRequest(petEntry);
                return;
            }
        }
        super.actionPerformed(buttonId);
    }

    @Override
    public int getDisplaySubspecies(CreatureInfo creatureInfo) {
        return this.playerExt.selectedPet.subspeciesID;
    }

    @Override
    public void playCreatureSelectSound(CreatureInfo creatureInfo) {
        this.player.func_130014_f_().func_184148_a(this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, ObjectManager.getSound(creatureInfo.getName() + "_tame"), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }
}

