/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui.beastiary;

import com.lycanitesmobs.core.VersionChecker;
import com.lycanitesmobs.core.gui.ButtonBase;
import com.lycanitesmobs.core.gui.beastiary.GuiBeastiary;
import com.lycanitesmobs.core.gui.beastiary.list.GuiIndexList;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiBeastiaryIndex
extends GuiBeastiary {
    public GuiIndexList indexList;

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent(LanguageManager.translate("gui.beastiary.index.title"), new Object[0]);
    }

    public GuiBeastiaryIndex(PlayerEntity player) {
        super(player);
    }

    @Override
    protected void initControls() {
        super.initControls();
        int menuWidth = this.colRightWidth;
        int buttonCount = 2;
        int buttonPadding = 2;
        int buttonWidth = Math.round(menuWidth / buttonCount) - buttonPadding;
        int buttonWidthPadded = buttonWidth + buttonPadding;
        int buttonHeight = 20;
        int buttonX = this.colRightX + buttonPadding;
        int buttonY = this.colRightY + this.colRightHeight - buttonHeight;
        ButtonBase button = new ButtonBase(100, buttonX, buttonY, buttonWidth, buttonHeight, "Website", this);
        this.buttons.add(button);
        button = new ButtonBase(101, buttonX + buttonWidthPadded, buttonY, buttonWidth, buttonHeight, "Patreon", this);
        this.buttons.add(button);
        this.indexList = new GuiIndexList(this, this.colRightWidth, this.colRightHeight, this.colRightY + 93, buttonY - buttonPadding, this.colRightX + 2);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void updateControls(int mouseX, int mouseY, float partialTicks) {
        super.updateControls(mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawForeground(mouseX, mouseY, partialTicks);
        int yOffset = this.colRightY + 13;
        String info = LanguageManager.translate("gui.beastiary.index.description");
        this.drawSplitString(info, this.colRightX + 1, yOffset, this.colRightWidth, 0xFFFFFF, true);
        yOffset += this.getFontRenderer().func_78267_b(info, this.colRightWidth);
        VersionChecker.VersionInfo latestVersion = VersionChecker.getLatestVersion(false);
        if (latestVersion == null) {
            return;
        }
        String version = "\n\u00c2\u00a7l" + LanguageManager.translate("gui.beastiary.index.version") + ": \u00c2\u00a7r";
        if (latestVersion.isNewer) {
            version = version + "\u00c2\u00a74";
        }
        version = version + "2.1.0.0\u00c2\u00a7r";
        if (latestVersion.isNewer) {
            version = version + " \u00c2\u00a7l" + LanguageManager.translate("gui.beastiary.index.version.newer") + ": \u00c2\u00a7r\u00c2\u00a72" + latestVersion.versionNumber + "\u00c2\u00a7r";
        }
        this.drawSplitString(version, this.colRightX + 1, yOffset, this.colRightWidth, 0xFFFFFF, true);
        yOffset += this.getFontRenderer().func_78267_b(version, this.colRightWidth);
        this.indexList.versionInfo = latestVersion;
        this.indexList.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void actionPerformed(byte buttonId) {
        if (buttonId == 100) {
            try {
                this.openURI(new URI("http://lycanitesmobs.com"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (buttonId == 101) {
            try {
                this.openURI(new URI("https://www.patreon.com/lycanite"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        super.actionPerformed(buttonId);
    }
}

