/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.gui.GuiListBase;
import com.lycanitesmobs.core.gui.GuiSummoningPedestal;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiSummoningPedestalList
extends GuiListBase<GuiSummoningPedestal> {
    GuiSummoningPedestal parentGUI;
    Map<Integer, String> minionList;

    public GuiSummoningPedestalList(GuiSummoningPedestal parentGUI, ExtendedPlayer playerExt, int width, int height, int top, int bottom, int left) {
        super(parentGUI, width, height, top, bottom, 28);
        this.setLeftPos(left);
        this.parentGUI = parentGUI;
        this.minionList = playerExt.getBeastiary().getSummonableList();
    }

    @Override
    public void createEntries() {
        for (String minionName : this.minionList.values()) {
            this.addEntry((AbstractList.AbstractListEntry)new SummoningPedestalEntry(this, minionName));
        }
    }

    protected int getItemCount() {
        return this.minionList.size();
    }

    protected void renderBackground() {
        super.renderBackground();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class SummoningPedestalEntry
    extends GuiListBase.Entry {
        GuiSummoningPedestalList parentGUI;
        String minionName;

        public SummoningPedestalEntry(GuiSummoningPedestalList list, String minionName) {
            this.parentGUI = list;
            this.minionName = minionName;
        }

        public void render(int index, int p_render_2_, int boxRight, int p_render_4_, int boxTop, int boxBottom, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(this.minionName);
            int boxLeft = this.parentGUI.getLeft();
            int levelBarWidth = 9;
            int levelBarHeight = 9;
            int levelBarX = boxLeft + 20;
            int levelBarY = boxTop + boxBottom - levelBarHeight - 4;
            int levelBarU = 256 - levelBarWidth * 2;
            int levelBarV = 256 - levelBarHeight;
            int level = creatureInfo.summonCost;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AssetManager.getTexture("GUIBeastiary"));
            for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
                ((GuiSummoningPedestal)((Object)this.parentGUI.screen)).drawTexturedModalRect(levelBarX + levelBarWidth * currentLevel, levelBarY, levelBarU, levelBarV, levelBarWidth, levelBarHeight);
            }
            ((GuiSummoningPedestal)((Object)this.parentGUI.screen)).getFontRenderer().func_211126_b(creatureInfo.getTitle(), (float)(this.parentGUI.getLeft() + 20), (float)(boxTop + 4), 0xFFFFFF);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(creatureInfo.getIcon());
            ((GuiSummoningPedestal)((Object)this.parentGUI.screen)).drawTexturedModalRect(this.parentGUI.getLeft() + 2, boxTop + 4, 0, 0, 16, 16, 16);
        }

        public List<? extends IGuiEventListener> children() {
            return null;
        }

        @Override
        protected void elementClicked() {
            ((GuiSummoningPedestal)((Object)this.parentGUI.screen)).selectMinion(this.minionName);
        }

        @Override
        protected boolean isSelected() {
            return false;
        }
    }
}

