/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.gui.GuiBase;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffSummoning;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.mobevent.MobEventPlayerClient;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class GuiOverlay
extends GuiBase {
    public Minecraft mc = Minecraft.func_71410_x();
    private int mountMessageTimeMax = 200;
    private int mountMessageTime = 0;

    public GuiOverlay(Minecraft minecraft) {
        super((ITextComponent)new TranslationTextComponent("gui.overlay", new Object[0]));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        ExtendedPlayer playerExt;
        if (ClientManager.getInstance().getClientPlayer() == null) {
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sWidth = Minecraft.func_71410_x().field_195558_d.func_198107_o();
        int sHeight = Minecraft.func_71410_x().field_195558_d.func_198087_p();
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(player.func_130014_f_());
        if (worldExt != null) {
            for (MobEventPlayerClient mobEventPlayerClient : worldExt.clientMobEventPlayers.values()) {
                GlStateManager.pushMatrix();
                mobEventPlayerClient.onGUIUpdate(this, sWidth, sHeight);
                GlStateManager.popMatrix();
            }
            if (worldExt.clientWorldEventPlayer != null) {
                GlStateManager.pushMatrix();
                worldExt.clientWorldEventPlayer.onGUIUpdate(this, sWidth, sHeight);
                GL11.glPopMatrix();
            }
        }
        if ((playerExt = ExtendedPlayer.getForPlayer(player)) != null && !this.mc.field_71439_g.field_71075_bZ.field_75098_d && (this.mc.field_71439_g.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemStaffSummoning || this.mc.field_71439_g.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof ItemStaffSummoning)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
            int barYSpace = 10;
            int barXSpace = -1;
            int summonBarWidth = 9;
            int summonBarHeight = 9;
            int summonBarX = sWidth / 2 + 10;
            int summonBarY = sHeight - 30 - summonBarHeight;
            int summonBarU = 256 - summonBarWidth;
            int summonBarV = 256 - summonBarHeight;
            summonBarY -= barYSpace;
            if (this.mc.field_71439_g.func_208600_a(FluidTags.field_206959_a)) {
                summonBarY -= barYSpace;
            }
            for (int summonBarEnergyN = 0; summonBarEnergyN < 10; ++summonBarEnergyN) {
                this.drawTexturedModalRect(summonBarX + (summonBarWidth + barXSpace) * summonBarEnergyN, summonBarY, summonBarU, summonBarV, summonBarWidth, summonBarHeight);
                if (playerExt.summonFocus >= playerExt.summonFocusMax - summonBarEnergyN * playerExt.summonFocusCharge) {
                    this.drawTexturedModalRect(summonBarX + (summonBarWidth + barXSpace) * summonBarEnergyN, summonBarY, summonBarU - summonBarWidth, summonBarV, summonBarWidth, summonBarHeight);
                    continue;
                }
                if (playerExt.summonFocus + playerExt.summonFocusCharge <= playerExt.summonFocusMax - summonBarEnergyN * playerExt.summonFocusCharge) continue;
                float summonChargeScale = (float)(playerExt.summonFocus % playerExt.summonFocusCharge) / (float)playerExt.summonFocusCharge;
                this.drawTexturedModalRect(summonBarX + (summonBarWidth + barXSpace) * summonBarEnergyN + (summonBarWidth - Math.round((float)summonBarWidth * summonChargeScale)), summonBarY, summonBarU - Math.round((float)summonBarWidth * summonChargeScale), summonBarV, Math.round((float)summonBarWidth * summonChargeScale), summonBarHeight);
            }
        }
        if (this.mc.field_71439_g.func_184187_bx() != null && this.mc.field_71439_g.func_184187_bx() instanceof EntityCreatureRideable) {
            EntityCreatureRideable mount = (EntityCreatureRideable)this.mc.field_71439_g.func_184187_bx();
            float mountStamina = mount.getStaminaPercent();
            if (this.mountMessageTime > 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.mountMessageTime < 60) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.mountMessageTime / 60.0f));
                }
                String mountMessage = LanguageManager.translate("gui.mount.controls");
                int stringWidth = this.mc.field_71466_p.func_78256_a(mountMessage);
                this.mc.field_71466_p.func_211126_b(mountMessage, (float)(sWidth / 2 - stringWidth / 2), (float)(sHeight - 64), 0xFFFFFF);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(GUI_ICONS_LOCATION);
            int staminaBarWidth = 182;
            int staminaBarHeight = 5;
            int staminaEnergyWidth = (int)((float)(staminaBarWidth + 1) * mountStamina);
            int staminaBarX = sWidth / 2 - staminaBarWidth / 2;
            int staminaBarY = sHeight - 32 + 3;
            int staminaTextureY = 84;
            if ("toggle".equals(mount.getStaminaType())) {
                staminaTextureY -= staminaBarHeight * 2;
            }
            int staminaEnergyY = staminaTextureY + staminaBarHeight;
            this.drawTexturedModalRect(staminaBarX, staminaBarY, 0, staminaTextureY, staminaBarWidth, staminaBarHeight);
            if (staminaEnergyWidth > 0) {
                this.drawTexturedModalRect(staminaBarX, staminaBarY, 0, staminaEnergyY, staminaEnergyWidth, staminaBarHeight);
            }
            if (this.mountMessageTime > 0) {
                --this.mountMessageTime;
            }
        } else {
            this.mountMessageTime = this.mountMessageTimeMax;
        }
        GlStateManager.popMatrix();
        this.mc.func_110434_K().func_110577_a(GUI_ICONS_LOCATION);
    }
}

