/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.projectile;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.creature.EntityCacodemon;
import com.lycanitesmobs.core.entity.projectile.EntityDemonicSpark;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityDemonicBlast
extends EntityProjectileBase {
    public Entity shootingEntity;
    public int expireTime = 15;
    private int rapidTicks = 0;

    public EntityDemonicBlast(EntityType<? extends EntityProjectileBase> entityType, World world) {
        super(entityType, world);
    }

    public EntityDemonicBlast(EntityType<? extends EntityProjectileBase> entityType, World world, LivingEntity entityLivingBase) {
        super(entityType, world, entityLivingBase);
    }

    public EntityDemonicBlast(EntityType<? extends EntityProjectileBase> entityType, World world, double x, double y, double z) {
        super(entityType, world, x, y, z);
    }

    @Override
    public void setup() {
        this.entityName = "demoniclightning";
        this.modInfo = LycanitesMobs.modInfo;
        this.setDamage(10);
        this.setProjectileScale(2.5f);
        this.ripper = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.rapidTicks % 5 == 0 && this.func_70089_S()) {
                for (int i = 0; i < 6; ++i) {
                    this.fireProjectile();
                }
            }
            if (this.rapidTicks == Integer.MAX_VALUE) {
                this.rapidTicks = -1;
            }
            ++this.rapidTicks;
        }
        if (this.field_70163_u > (double)(this.func_130014_f_().func_72940_L() + 20)) {
            this.func_70106_y();
        }
        if (this.field_70173_aa >= this.expireTime * 20) {
            this.func_70106_y();
        }
    }

    public void fireProjectile() {
        EntityDemonicSpark projectile;
        World world = this.func_130014_f_();
        if (this.func_85052_h() != null) {
            projectile = new EntityDemonicSpark(ProjectileManager.getInstance().oldProjectileTypes.get(EntityDemonicSpark.class), world, this.func_85052_h());
            projectile.field_70165_t = this.field_70165_t;
            projectile.field_70163_u = this.field_70163_u;
            projectile.field_70161_v = this.field_70161_v;
        } else {
            projectile = new EntityDemonicSpark(ProjectileManager.getInstance().oldProjectileTypes.get(EntityDemonicSpark.class), world, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        float velocity = 1.2f;
        double motionT = this.func_213322_ci().func_82615_a() + this.func_213322_ci().func_82617_b() + this.func_213322_ci().func_82616_c();
        if (this.func_213322_ci().func_82615_a() < 0.0) {
            motionT -= this.func_213322_ci().func_82615_a() * 2.0;
        }
        if (this.func_213322_ci().func_82617_b() < 0.0) {
            motionT -= this.func_213322_ci().func_82617_b() * 2.0;
        }
        if (this.func_213322_ci().func_82616_c() < 0.0) {
            motionT -= this.func_213322_ci().func_82616_c() * 2.0;
        }
        projectile.func_70186_c(this.func_213322_ci().func_82615_a() / motionT + (this.field_70146_Z.nextGaussian() - 0.5), this.func_213322_ci().func_82617_b() / motionT + (this.field_70146_Z.nextGaussian() - 0.5), this.func_213322_ci().func_82616_c() / motionT + (this.field_70146_Z.nextGaussian() - 0.5), velocity, 0.0f);
        this.func_184185_a(((EntityProjectileBase)projectile).getLaunchSound(), 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        world.func_217376_c((Entity)projectile);
    }

    @Override
    protected float func_70185_h() {
        return 1.0E-4f;
    }

    @Override
    public boolean onEntityLivingDamage(LivingEntity entityLiving) {
        entityLiving.func_195064_c(new EffectInstance(Effects.field_82731_v, this.getEffectDuration(10), 0));
        if (ObjectManager.getEffect("decay") != null) {
            entityLiving.func_195064_c(new EffectInstance((Effect)ObjectManager.getEffect("decay"), this.getEffectDuration(60), 0));
        }
        return true;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (this.func_85052_h() != null && this.func_85052_h().func_184187_bx() == entity) {
            return;
        }
        if (this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing")) {
            int explosionRadius = 2;
            if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
                EntityCreatureBase entityCreatureBase = (EntityCreatureBase)this.func_85052_h();
                if (entityCreatureBase instanceof EntityCacodemon && !((EntityCacodemon)entityCreatureBase).cacodemonGreifing) {
                    super.onImpactComplete(this.func_180425_c());
                    return;
                }
                if (entityCreatureBase.getOwner() == entity || entityCreatureBase.func_184179_bs() == entity) {
                    super.onImpactComplete(this.func_180425_c());
                    return;
                }
                if (entityCreatureBase.getSubspeciesIndex() > 0) {
                    explosionRadius += 2;
                }
                if (entityCreatureBase.getSubspeciesIndex() > 2) {
                    explosionRadius = 2;
                }
            }
            this.func_130014_f_().func_217385_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionRadius, Explosion.Mode.BREAK);
        }
        for (int i = 0; i < 8; ++i) {
            this.fireProjectile();
        }
    }

    @Override
    public void onImpactVisuals() {
        for (int i = 0; i < 8; ++i) {
            this.func_130014_f_().func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public SoundEvent getLaunchSound() {
        return ObjectManager.getSound("DemonicBlast");
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

