/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.targeting.TargetingGoal;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;

public class ParentTargetingGoal
extends TargetingGoal {
    private EntityCreatureAgeable host;
    private Class targetClass;
    private boolean tameTargeting = true;
    private int targetChance = 0;
    private double targetDistance = -1.0;

    public ParentTargetingGoal(EntityCreatureAgeable setHost) {
        super(setHost);
        this.host = setHost;
        this.targetClass = ((Object)((Object)this.host)).getClass();
    }

    public ParentTargetingGoal setChance(int setChance) {
        this.targetChance = setChance;
        return this;
    }

    public ParentTargetingGoal setTargetClass(Class setTargetClass) {
        this.targetClass = setTargetClass;
        return this;
    }

    public ParentTargetingGoal setSightCheck(boolean setSightCheck) {
        this.checkSight = setSightCheck;
        return this;
    }

    public ParentTargetingGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public ParentTargetingGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    public ParentTargetingGoal setDistance(double setDist) {
        this.targetDistance = setDist;
        return this;
    }

    public ParentTargetingGoal setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    @Override
    protected LivingEntity getTarget() {
        return this.host.getParentTarget();
    }

    @Override
    protected void setTarget(LivingEntity newTarget) {
        this.host.setParentTarget(newTarget);
    }

    @Override
    protected boolean isValidTarget(LivingEntity target) {
        if (this.targetClass != null && !this.targetClass.isAssignableFrom(target.getClass())) {
            return false;
        }
        if (target instanceof AnimalEntity && ((AnimalEntity)target).func_70874_b() < 0) {
            return false;
        }
        if (target instanceof EntityCreatureAgeable && ((EntityCreatureAgeable)target).getGrowingAge() < 0) {
            return false;
        }
        return this.tameTargeting || !(this.host instanceof EntityCreatureTameable) || !this.host.isTamed();
    }

    @Override
    protected double getTargetDistance() {
        if (this.targetDistance > -1.0) {
            return this.targetDistance;
        }
        IAttributeInstance attributeinstance = this.host.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attributeinstance.func_111126_e();
    }

    public boolean func_75250_a() {
        if (this.host.updateTick % 20L != 0L) {
            return false;
        }
        this.target = null;
        if (this.host.getGrowingAge() >= 0) {
            this.host.setParentTarget(null);
            return false;
        }
        if (this.host.updateTick % 20L != 0L && this.targetChance > 0 && this.host.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        double distance = this.getTargetDistance();
        double heightDistance = 4.0;
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        return this.target != null;
    }

    @Override
    public boolean func_75253_b() {
        if (this.host.getGrowingAge() >= 0) {
            this.host.setParentTarget(null);
            return false;
        }
        return super.func_75253_b();
    }
}

