/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.targeting.TargetingGoal;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;

public class MasterTargetingGoal
extends TargetingGoal {
    private Class targetClass = LivingEntity.class;
    private boolean tameTargeting = false;
    private int targetChance = 0;

    public MasterTargetingGoal(EntityCreatureBase setHost) {
        super(setHost);
    }

    public MasterTargetingGoal setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    public MasterTargetingGoal setChance(int setChance) {
        this.targetChance = setChance;
        return this;
    }

    public MasterTargetingGoal setTargetClass(Class setTargetClass) {
        this.targetClass = setTargetClass;
        return this;
    }

    public MasterTargetingGoal setSightCheck(boolean setSightCheck) {
        this.checkSight = setSightCheck;
        return this;
    }

    public MasterTargetingGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public MasterTargetingGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    public MasterTargetingGoal setRange(double setDist) {
        this.targetingRange = setDist;
        return this;
    }

    @Override
    protected LivingEntity getTarget() {
        return this.host.getMasterTarget();
    }

    @Override
    protected void setTarget(LivingEntity newTarget) {
        this.host.setMasterTarget(newTarget);
    }

    @Override
    protected boolean isValidTarget(LivingEntity target) {
        if (this.targetClass != null && !this.targetClass.isAssignableFrom(target.getClass())) {
            return false;
        }
        if (target instanceof AnimalEntity && ((AnimalEntity)target).func_70874_b() < 0) {
            return false;
        }
        if (target instanceof EntityCreatureAgeable && ((EntityCreatureAgeable)target).getGrowingAge() < 0) {
            return false;
        }
        return this.tameTargeting || !(this.host instanceof EntityCreatureTameable) || !((EntityCreatureTameable)this.host).isTamed();
    }

    @Override
    protected double getTargetDistance() {
        if (this.targetingRange > 0.0) {
            return this.targetingRange;
        }
        IAttributeInstance attributeinstance = this.host.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attributeinstance.func_111126_e();
    }

    public boolean func_75250_a() {
        if (this.host.updateTick % 20L != 0L) {
            return false;
        }
        if (this.targetChance > 0 && this.host.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        this.target = null;
        double distance = this.getTargetDistance();
        double heightDistance = 4.0;
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        return this.target != null;
    }
}

