/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.Targeting;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.goals.targeting.TargetingGoal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.Difficulty;

public class AttackTargetingGoal
extends TargetingGoal {
    public Class targetClass = LivingEntity.class;
    private List<Class> targetClasses = new ArrayList<Class>();
    private int targetChance = 0;
    protected boolean tameTargeting = false;
    private int allySize = 0;
    private int enemySize = 0;
    private static List<Class> VILLAGER_CLASSES = Arrays.asList(VillagerEntity.class, PillagerEntity.class);

    public AttackTargetingGoal(EntityCreatureBase setHost) {
        super(setHost);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public AttackTargetingGoal setChance(int setChance) {
        this.targetChance = setChance;
        return this;
    }

    public AttackTargetingGoal setCheckSight(boolean bool) {
        this.checkSight = bool;
        return this;
    }

    public AttackTargetingGoal setTargetClass(Class setTargetClass) {
        this.targetClass = setTargetClass;
        if (setTargetClass == VillagerEntity.class) {
            this.setTargetClasses(VILLAGER_CLASSES);
        }
        return this;
    }

    public AttackTargetingGoal setTargetClasses(List<Class> classList) {
        this.targetClasses = classList;
        return this;
    }

    public AttackTargetingGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public AttackTargetingGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    public AttackTargetingGoal setRange(double range) {
        this.targetingRange = range;
        return this;
    }

    public AttackTargetingGoal setHelpCall(boolean setHelp) {
        this.callForHelp = setHelp;
        return this;
    }

    public AttackTargetingGoal setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    public AttackTargetingGoal setPackHuntingScale(int setAllySize, int setEnemySize) {
        this.allySize = setAllySize;
        this.enemySize = setEnemySize;
        return this;
    }

    @Override
    protected LivingEntity getTarget() {
        return this.host.func_70638_az();
    }

    @Override
    protected void setTarget(LivingEntity newTarget) {
        this.host.func_70624_b(newTarget);
    }

    @Override
    protected boolean isValidTarget(LivingEntity target) {
        if (!this.targetClasses.isEmpty()) {
            boolean foundTarget = false;
            for (Class targetClass : this.targetClasses) {
                if (!targetClass.isAssignableFrom(target.getClass())) continue;
                foundTarget = true;
                break;
            }
            if (!foundTarget) {
                return false;
            }
        } else if (this.targetClass != null && !this.targetClass.isAssignableFrom(target.getClass())) {
            return false;
        }
        if (this.targetClass != ((Object)((Object)this.host)).getClass() && target.getClass() == ((Object)((Object)this.host)).getClass()) {
            return false;
        }
        if (this.host.func_130014_f_().func_175659_aa() == Difficulty.PEACEFUL && target instanceof PlayerEntity) {
            return false;
        }
        if (!this.tameTargeting && this.host.isTamed()) {
            return false;
        }
        if ((this.targetClass == IGroupAnimal.class || this.targetClass == IGroupAlpha.class) && target instanceof IGroupPredator) {
            return false;
        }
        if (!this.host.func_213358_a(target.func_200600_R())) {
            return false;
        }
        if (!this.host.func_213336_c(target)) {
            return false;
        }
        if (!Targeting.isValidTarget((Entity)this.host, (Entity)target)) {
            return false;
        }
        if (this.allySize > 0 && this.enemySize > 0) {
            try {
                double hostPackRange = 32.0;
                double hostPackSize = this.host.func_130014_f_().func_217357_a(((Object)((Object)this.host)).getClass(), this.host.func_174813_aQ().func_72314_b(hostPackRange, hostPackRange, hostPackRange)).size();
                double hostPackScale = hostPackSize / (double)this.allySize;
                double targetPackRange = 64.0;
                double targetPackSize = target.func_130014_f_().func_175647_a(LivingEntity.class, target.func_174813_aQ().func_72314_b(targetPackRange, targetPackRange, targetPackRange), (Predicate)((com.google.common.base.Predicate)entity -> entity.getClass().isAssignableFrom(this.targetClass))).size();
                double targetPackScale = targetPackSize / (double)this.enemySize;
                if (hostPackScale < targetPackScale) {
                    return false;
                }
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "An exception occurred when assessing pack sizes, this has been skipped to prevent a crash.");
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean func_75250_a() {
        if (!this.host.func_213398_dR() || this.host.hasFixateTarget()) {
            return false;
        }
        if (this.targetClass == PlayerEntity.class ? this.host.updateTick % 10L != 0L : this.host.updateTick % 40L != 0L) {
            return false;
        }
        if (this.targetChance > 0 && this.host.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        this.target = null;
        double distance = this.getTargetDistance();
        double heightDistance = 4.0 + (double)this.host.func_213302_cg();
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        if (this.callForHelp) {
            this.callNearbyForHelp();
        }
        return this.target != null;
    }

    @Override
    public LivingEntity getNewTarget(double rangeX, double rangeY, double rangeZ) {
        if (this.targetClass == PlayerEntity.class) {
            LivingEntity newTarget = null;
            try {
                List players = this.host.func_130014_f_().func_217369_A();
                if (players.isEmpty()) {
                    return null;
                }
                ArrayList<PlayerEntity> possibleTargets = new ArrayList<PlayerEntity>();
                for (PlayerEntity player : players) {
                    if (!this.isValidTarget((LivingEntity)player)) continue;
                    possibleTargets.add(player);
                }
                if (possibleTargets.isEmpty()) {
                    return null;
                }
                Collections.sort(possibleTargets, this.nearestSorter);
                newTarget = (LivingEntity)possibleTargets.get(0);
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "An exception occurred when player target selecting, this has been skipped to prevent a crash.");
                e.printStackTrace();
            }
            return newTarget;
        }
        return super.getNewTarget(rangeX, rangeY, rangeZ);
    }
}

