/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class AttackMeleeGoal
extends Goal {
    private EntityCreatureBase host;
    private LivingEntity attackTarget;
    private Path pathToTarget;
    private double speed = 1.0;
    private Class targetClass;
    private boolean longMemory = true;
    private int attackTime;
    private double attackRange = 0.5;
    private float maxChaseDistance = 1024.0f;
    private double damage = 1.0;
    public boolean enabled = true;
    private int failedPathFindingPenalty;
    private int failedPathFindingPenaltyMax = 0;
    private int repathTime;

    public AttackMeleeGoal(EntityCreatureBase setHost) {
        this.host = setHost;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public AttackMeleeGoal setSpeed(double setSpeed) {
        this.speed = setSpeed;
        return this;
    }

    public AttackMeleeGoal setDamage(double scale) {
        this.damage = scale;
        return this;
    }

    public AttackMeleeGoal setTargetClass(Class setTargetClass) {
        this.targetClass = setTargetClass;
        return this;
    }

    public AttackMeleeGoal setLongMemory(boolean setMemory) {
        this.longMemory = setMemory;
        return this;
    }

    public AttackMeleeGoal setRange(double range) {
        this.attackRange = range;
        return this;
    }

    public AttackMeleeGoal setMaxChaseDistanceSq(float distance) {
        this.maxChaseDistance = distance * distance;
        return this;
    }

    public AttackMeleeGoal setMaxChaseDistance(float distance) {
        this.maxChaseDistance = distance;
        return this;
    }

    public AttackMeleeGoal setMissRate(int rate) {
        this.failedPathFindingPenaltyMax = rate;
        return this;
    }

    public AttackMeleeGoal setEnabled(boolean setEnabled) {
        this.enabled = setEnabled;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.enabled) {
            return false;
        }
        this.attackTarget = this.host.func_70638_az();
        if (this.attackTarget == null) {
            return false;
        }
        if (!this.attackTarget.func_70089_S()) {
            return false;
        }
        if (this.host.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v) > (double)this.maxChaseDistance) {
            return false;
        }
        if (this.targetClass != null && !this.targetClass.isAssignableFrom(this.attackTarget.getClass())) {
            return false;
        }
        if (--this.repathTime <= 0) {
            if (!this.host.useDirectNavigator()) {
                this.pathToTarget = this.host.isFlying() ? this.host.func_70661_as().func_75488_a(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b + this.host.getFlightOffset(), this.attackTarget.field_70161_v) : this.host.func_70661_as().func_75494_a((Entity)this.attackTarget);
                this.repathTime = 4 + this.host.func_70681_au().nextInt(7);
                return this.pathToTarget != null;
            }
            return this.host.directNavigator.setTargetPosition(new BlockPos((double)((int)this.attackTarget.field_70165_t), (double)((int)this.attackTarget.field_70163_u) + this.host.getFlightOffset(), (double)((int)this.attackTarget.field_70161_v)), this.speed);
        }
        return true;
    }

    public boolean func_75253_b() {
        if (!this.enabled) {
            return false;
        }
        this.attackTarget = this.host.func_70638_az();
        if (this.attackTarget == null) {
            return false;
        }
        if (!this.host.func_70089_S() || !this.attackTarget.func_70089_S()) {
            return false;
        }
        if (this.host.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v) > (double)this.maxChaseDistance) {
            return false;
        }
        if (!this.longMemory) {
            if (!this.host.useDirectNavigator() && this.host.func_70661_as().func_75500_f()) {
                return false;
            }
            if (this.host.useDirectNavigator() && (this.host.directNavigator.atTargetPosition() || !this.host.directNavigator.isTargetPositionValid())) {
                return false;
            }
        }
        return this.host.positionNearHome(MathHelper.func_76128_c((double)this.attackTarget.field_70165_t), MathHelper.func_76128_c((double)this.attackTarget.field_70163_u), MathHelper.func_76128_c((double)this.attackTarget.field_70161_v));
    }

    public void func_75249_e() {
        if (!this.host.useDirectNavigator()) {
            this.host.func_70661_as().func_75484_a(this.pathToTarget, this.speed);
        } else if (this.attackTarget != null) {
            this.host.directNavigator.setTargetPosition(new BlockPos((int)this.attackTarget.field_70165_t, (int)(this.attackTarget.func_174813_aQ().field_72338_b + this.host.getFlightOffset()), (int)this.attackTarget.field_70161_v), this.speed);
        }
        this.repathTime = 0;
    }

    public void func_75251_c() {
        this.host.func_70661_as().func_75499_g();
        this.host.directNavigator.clearTargetPosition(1.0);
        this.attackTarget = null;
    }

    public void func_75246_d() {
        LivingEntity attackTarget = this.host.func_70638_az();
        this.host.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
        if ((this.longMemory || this.host.func_70635_at().func_75522_a((Entity)attackTarget)) && --this.repathTime <= 0) {
            this.repathTime = this.failedPathFindingPenalty + 4 + this.host.func_70681_au().nextInt(7);
            if (!this.host.useDirectNavigator()) {
                PathPoint finalPathPoint;
                if (this.host.isFlying()) {
                    this.host.func_70661_as().func_75492_a(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b + this.host.getFlightOffset(), this.attackTarget.field_70161_v, this.speed);
                } else {
                    this.host.func_70661_as().func_75497_a((Entity)attackTarget, this.speed);
                }
                this.failedPathFindingPenalty = this.host.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.host.func_70661_as().func_75505_d().func_75870_c()) != null && attackTarget.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += this.failedPathFindingPenaltyMax)) : (this.failedPathFindingPenalty += this.failedPathFindingPenaltyMax);
            } else {
                this.host.directNavigator.setTargetPosition(new BlockPos((int)attackTarget.field_70165_t, (int)(attackTarget.func_174813_aQ().field_72338_b + this.host.getFlightOffset()), (int)attackTarget.field_70161_v), this.speed);
            }
        }
        if (this.host.func_70092_e(attackTarget.field_70165_t, attackTarget.func_174813_aQ().field_72338_b + this.host.getFlightOffset(), attackTarget.field_70161_v) <= this.getAttackRange(attackTarget)) {
            if (--this.attackTime <= 0) {
                this.attackTime = this.host.getMeleeCooldown();
                if (!this.host.func_184614_ca().func_190926_b()) {
                    this.host.func_184609_a(Hand.MAIN_HAND);
                }
                this.host.attackMelee((Entity)attackTarget, this.damage);
            }
            double d0 = this.host.field_70165_t - attackTarget.field_70165_t;
            double d1 = this.host.field_70161_v - attackTarget.field_70161_v;
            float f = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) + 90.0f;
            if ((f = MathHelper.func_76142_g((float)(f - this.host.field_70177_z))) < -30.0f) {
                f = -30.0f;
            }
            if (f > 30.0f) {
                f = 30.0f;
            }
            this.host.field_70177_z += f;
        }
    }

    protected double getAttackRange(LivingEntity attackTarget) {
        double range = this.host.getMeleeAttackRange();
        return range += this.attackRange + (double)attackTarget.func_213305_a((Pose)Pose.STANDING).field_220315_a;
    }
}

