/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupElectric;
import com.lycanitesmobs.api.IGroupWater;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityZephyr
extends EntityCreatureTameable
implements IMob,
IGroupWater,
IGroupElectric {
    protected short aoeAttackTick = 0;

    public EntityZephyr(EntityType<? extends EntityZephyr> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackMeleeGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        LivingEntity target;
        List<LivingEntity> aoeTargets;
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && (this.aoeAttackTick = (short)(this.aoeAttackTick + 1)) == (this.isPetType("familiar") ? (short)100 : 40)) {
            this.aoeAttackTick = 0;
            aoeTargets = this.getNearbyEntities(LivingEntity.class, null, 4.0);
            for (LivingEntity entityObj : aoeTargets) {
                target = entityObj;
                if (target == this || target instanceof IGroupElectric || !this.func_213358_a(target.func_200600_R()) || !this.func_213336_c(target) || !this.func_70635_at().func_75522_a((Entity)target)) continue;
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.getAttackDamage(1.0));
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            aoeTargets = this.getNearbyEntities(LivingEntity.class, null, 4.0);
            for (LivingEntity entityObj : aoeTargets) {
                target = entityObj;
                if (!this.func_213358_a(target.func_200600_R()) || !this.func_213336_c(target) || !this.func_70635_at().func_75522_a((Entity)target)) continue;
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197614_g, target.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)target.func_213305_a((Pose)Pose.STANDING).field_220315_a, target.field_70163_u + this.field_70146_Z.nextDouble() * (double)target.func_213305_a((Pose)Pose.STANDING).field_220316_b, target.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)target.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if ("lightningBolt".equalsIgnoreCase(type)) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

