/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.api.IGroupRock;
import com.lycanitesmobs.api.IGroupWater;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class EntityVolcan
extends EntityCreatureTameable
implements IMob,
IGroupRock,
IGroupFire {
    private AttackMeleeGoal meleeAttackAI;
    public int volcanMeltRadius = 2;

    public EntityVolcan(EntityType<? extends EntityVolcan> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.meleeAttackAI = new AttackMeleeGoal(this).setLongMemory(true);
        this.field_70714_bg.func_75776_a(2, (Goal)this.meleeAttackAI);
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupIce.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupWater.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(SnowGolemEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(SilverfishEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPlant.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L) {
            List<LivingEntity> aoeTargets = this.getNearbyEntities(LivingEntity.class, null, 4.0);
            for (LivingEntity entityObj : aoeTargets) {
                LivingEntity target = entityObj;
                if (target == this || target instanceof IGroupFire || !this.func_213358_a(target.func_200600_R()) || !this.func_213336_c(target) || !this.func_70635_at().func_75522_a((Entity)target)) continue;
                target.func_70015_d(2);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L && this.volcanMeltRadius > 0 && !this.isTamed() && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing")) {
            int range = this.volcanMeltRadius;
            int w = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + range);
            while ((double)w <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
                int d = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + range);
                while ((double)d <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
                    int h = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220316_b) + range);
                    while ((double)h <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220316_b)) {
                        Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(w, h, d)).func_177230_c();
                        if (block == Blocks.field_150343_Z || block == Blocks.field_150347_e || block == Blocks.field_150351_n) {
                            BlockState blockState = (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(5));
                            if (block == Blocks.field_150343_Z) {
                                blockState = Blocks.field_150353_l.func_176223_P();
                            }
                            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(w, h, d), blockState);
                        }
                        ++h;
                    }
                    ++d;
                }
                ++w;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197617_j, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
            if (this.field_70173_aa % 10 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof SilverfishEntity) {
            target.func_70106_y();
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public void performCommand(String command, PlayerEntity player, ItemStack itemStack) {
        if (command.equals("Water")) {
            this.replacePlayersItem(player, itemStack, new ItemStack((IItemProvider)Items.field_151129_at));
        }
        super.performCommand(command, player, itemStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }
}

