/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.BreakDoorGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityBoulderBlast;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityTroll
extends EntityCreatureTameable
implements IMob {
    public boolean trollGreifing = true;
    public boolean stoneForm = false;

    public EntityTroll(EntityType<? extends EntityTroll> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.solidCollision = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.func_70661_as() instanceof GroundPathNavigator) {
            GroundPathNavigator pathNavigateGround = (GroundPathNavigator)this.func_70661_as();
            pathNavigateGround.func_179688_b(true);
        }
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakDoorGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackRangedGoal(this).setSpeed(0.5).setRange(14.0f).setMinChaseDistance(5.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public String getTextureName() {
        if (this.stoneForm) {
            return super.getTextureName() + "_stone";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        float distance;
        super.func_70636_d();
        if (!this.stoneForm) {
            if (this.isDaytime() && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
                this.stoneForm = true;
            }
        } else if (!this.isDaytime() || !this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            this.stoneForm = false;
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.trollGreifing && (distance = this.func_70638_az().func_70032_d((Entity)this)) <= this.func_213305_a((Pose)Pose.STANDING).field_220315_a + 4.0f) {
            this.destroyArea((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10.0f, true);
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.stoneForm) {
            return 0.125f;
        }
        return 1.0f;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityBoulderBlast.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if ("Jarno".equals(this.func_200201_e())) {
            return 0.0f;
        }
        if (this.stoneForm) {
            if (damageSrc.func_76346_g() != null) {
                LivingEntity entityLiving;
                Item heldItem = null;
                if (damageSrc.func_76346_g() instanceof LivingEntity && !(entityLiving = (LivingEntity)damageSrc.func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                    heldItem = entityLiving.func_184586_b(Hand.MAIN_HAND).func_77973_b();
                }
                if (ObjectLists.isPickaxe(heldItem)) {
                    return 2.0f;
                }
            }
            return 0.25f;
        }
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getFallResistance() {
        return 50.0f;
    }

    @Override
    public boolean canBurn() {
        return !this.stoneForm;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

