/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupRock;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityTremor
extends EntityCreatureTameable
implements IMob,
IGroupRock {
    private AttackMeleeGoal meleeAttackAI;
    public int tremorExplosionStrength = 1;

    public EntityTremor(EntityType<? extends EntityTremor> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.meleeAttackAI = new AttackMeleeGoal(this).setLongMemory(true);
        this.field_70714_bg.func_75776_a(2, (Goal)this.meleeAttackAI);
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.getSubspeciesIndex() == 3 && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.func_70681_au().nextInt(20) == 0) {
            if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
            } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
            } else {
                this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        Explosion.Mode damageTerrain;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        int explosionStrength = Math.max(1, this.tremorExplosionStrength);
        Explosion.Mode mode = damageTerrain = this.tremorExplosionStrength > 0 && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
        if (this.isPetType("familiar")) {
            explosionStrength = 1;
            damageTerrain = Explosion.Mode.NONE;
        }
        this.func_130014_f_().func_217385_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionStrength, damageTerrain);
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (source.func_94541_c()) {
            this.func_70691_i(damage);
            return false;
        }
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean isInvulnerableTo(Entity entity) {
        if (entity instanceof WitherEntity) {
            return false;
        }
        return super.isInvulnerableTo(entity);
    }

    @Override
    public boolean func_70687_e(EffectInstance effectInstance) {
        if (effectInstance.func_188419_a() == Effects.field_82731_v) {
            return false;
        }
        return super.func_70687_e(effectInstance);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean canBeTargetedBy(LivingEntity entity) {
        if (entity instanceof WitherEntity) {
            return false;
        }
        return super.canBeTargetedBy(entity);
    }
}

