/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;

public class EntityTarantula
extends EntityCreatureTameable
implements IMob {
    public EntityTarantula(EntityType<? extends EntityTarantula> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(5, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
            this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(ChickenEntity.class));
        }
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            if (this.hasAttackTarget()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.leap(6.0f, 0.6, (Entity)this.func_70638_az());
                }
            } else if (this.field_70146_Z.nextInt(50) == 0 && this.isMoving()) {
                this.leap(1.0, 1.0);
            }
        }
        if (!this.func_130014_f_().field_72995_K && (this.field_70173_aa % 10 == 0 || this.isMoving() && this.field_70173_aa % 5 == 0)) {
            int trailHeight = 1;
            for (int y = 0; y < trailHeight; ++y) {
                Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, y, 0)).func_177230_c();
                if (block != Blocks.field_150350_a && block != Blocks.field_150433_aE && block != ObjectManager.getBlock("quickweb")) continue;
                this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, y, 0), ObjectManager.getBlock("quickweb").func_176223_P());
            }
        }
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public boolean webProof() {
        return true;
    }
}

