/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.BegGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByWaterGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntitySkylus
extends EntityCreatureTameable
implements IMob,
IGroupPredator {
    WanderGoal wanderAI;
    public AttackMeleeGoal attackAI;

    public EntitySkylus(EntityType<? extends EntitySkylus> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.01;
        this.canGrow = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new StayByWaterGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.aiSit);
        this.attackAI = new AttackMeleeGoal(this).setLongMemory(false).setRange(1.0);
        this.field_70714_bg.func_75776_a(3, (Goal)this.attackAI);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.wanderAI = new WanderGoal(this);
        this.field_70714_bg.func_75776_a(6, (Goal)this.wanderAI);
        this.field_70714_bg.func_75776_a(9, (Goal)new BegGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAnimal.class).setPackHuntingScale(1, 3));
            this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(AnimalEntity.class).setPackHuntingScale(1, 3));
        }
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70090_H()) {
                this.wanderAI.setPauseRate(20);
            } else {
                this.wanderAI.setPauseRate(0);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null && this.hasPickupEntity()) {
            ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
            if (extendedEntity != null) {
                extendedEntity.setPickedUpByEntity((Entity)this);
            }
            if (this.field_70173_aa % 100 == 0 && this.func_70681_au().nextBoolean()) {
                this.dropPickupEntity();
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
            return 1.0f;
        }
        return 2.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public void pickupEntity(LivingEntity entity) {
        super.pickupEntity(entity);
        this.leap(-1.0, -0.5);
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 0.0, 2.0};
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        LivingEntity entityLivingBase;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof LivingEntity && this.canPickupEntity(entityLivingBase = (LivingEntity)target)) {
            this.pickupEntity(entityLivingBase);
        }
        return true;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return false;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
            return 0.25f;
        }
        return 1.0f;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

