/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.api.IGroupShadow;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.BegGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderRevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityShade
extends EntityCreatureRideable
implements IGroupPredator,
IGroupHunter,
IGroupShadow {
    public EntityShade(EntityType<? extends EntityShade> entityType, World world) {
        super((EntityType<? extends EntityCreatureRideable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.hasJumpSound = true;
        this.canGrow = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackCooldownMax = 40;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new AttackMeleeGoal(this).setSpeed(1.5));
        this.field_70714_bg.func_75776_a(7, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new WanderGoal(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new BegGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RiderRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RiderAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new RevengeTargetingGoal(this));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(CowEntity.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(PigEntity.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(SheepEntity.class).setTameTargetting(true));
        }
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(ZombiePigmanEntity.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAlpha.class));
            this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(AnimalEntity.class));
        }
        this.field_70715_bh.func_75776_a(9, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(10, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 100.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.85;
    }

    @Override
    public double getMountedZOffset() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 0.25;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        float leeching = this.getEffectStrength(this.getAttackDamage(damageScale) / 4.0f);
        this.func_70691_i(leeching);
        if (this.func_70681_au().nextFloat() <= 0.1f) {
            this.specialAttack();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.func_130014_f_().func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), possibleTarget -> possibleTarget.func_70089_S() && possibleTarget != this && !this.func_184215_y((Entity)possibleTarget) && !this.func_184191_r((Entity)possibleTarget) && this.func_213358_a(possibleTarget.func_200600_R()) && this.func_213336_c((LivingEntity)possibleTarget));
        if (!possibleTargets.isEmpty()) {
            for (LivingEntity possibleTarget2 : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((PlayerEntity)this.getRider(), (Entity)possibleTarget2))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                if (ObjectManager.getEffect("fear") != null) {
                    possibleTarget2.func_195064_c(new EffectInstance((Effect)ObjectManager.getEffect("fear"), this.getEffectDuration(5), 1));
                    continue;
                }
                possibleTarget2.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 0));
            }
        }
        this.playAttackSound();
        this.triggerAttackCooldown();
    }

    @Override
    public boolean canBeTempted() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

