/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.BegGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.PlayerControlGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderRevengeTargetingGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRoc
extends EntityCreatureRideable
implements IMob,
IGroupHunter {
    public AttackMeleeGoal attackAI;
    public boolean creeperDropping = true;
    private int creeperDropCooldown = 0;

    public EntityRoc(EntityType<? extends EntityRoc> entityType, World world) {
        super((EntityType<? extends EntityCreatureRideable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.flySoundSpeed = 20;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PlayerControlGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.attackAI = new AttackMeleeGoal(this).setLongMemory(false);
        this.field_70714_bg.func_75776_a(5, (Goal)this.attackAI);
        this.field_70714_bg.func_75776_a(6, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this).setPauseRate(0));
        this.field_70714_bg.func_75776_a(9, (Goal)new BegGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RiderRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RiderAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(CreeperEntity.class));
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null) {
            this.attackAI.setEnabled(this.hasPickupEntity() ? this.getPickupEntity() instanceof CreeperEntity : this.creeperDropCooldown <= 0);
            if (this.creeperDropCooldown > 0) {
                --this.creeperDropCooldown;
            }
            if (this.hasPickupEntity()) {
                double distance;
                ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
                if (extendedEntity != null) {
                    extendedEntity.setPickedUpByEntity((Entity)this);
                }
                if (this.getPickupEntity() instanceof CreeperEntity && this.hasAttackTarget() && !(this.func_70638_az() instanceof CreeperEntity) && (distance = new Vec3d(this.field_70165_t, 0.0, this.field_70161_v).func_72438_d(new Vec3d(this.func_70638_az().field_70165_t, 0.0, this.func_70638_az().field_70161_v))) <= 2.0 && this.field_70163_u > this.func_70638_az().field_70163_u) {
                    this.getPickupEntity().func_70604_c(this.func_70638_az());
                    this.dropPickupEntity();
                    this.creeperDropCooldown = 120;
                }
                if (this.hasPickupEntity() && this.field_70173_aa % 100 == 0 && this.func_70681_au().nextBoolean()) {
                    if (this.getPickupEntity() instanceof PlayerEntity) {
                        for (int distToGround = 0; distToGround < 8; ++distToGround) {
                            Block searchBlock = this.func_130014_f_().func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u - distToGround, (int)this.field_70161_v)).func_177230_c();
                            if (searchBlock == null || searchBlock == Blocks.field_150350_a) continue;
                            this.dropPickupEntity();
                            this.leap(1.0, 2.0);
                            break;
                        }
                    } else if (!(this.getPickupEntity() instanceof CreeperEntity)) {
                        this.dropPickupEntity();
                    }
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null && this.getPickupEntity() instanceof CreeperEntity) {
            ((CreeperEntity)this.getPickupEntity()).func_70624_b(null);
        }
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        if (rider.func_70644_a(Effects.field_76437_t)) {
            rider.func_195063_d(Effects.field_76437_t);
        }
        if (rider.func_70644_a(Effects.field_76419_f)) {
            rider.func_195063_d(Effects.field_76419_f);
        }
    }

    @Override
    public double getFlightOffset() {
        if (this.hasPickupEntity()) {
            return 5.0;
        }
        return super.getFlightOffset();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof LivingEntity && this.func_184179_bs() == null) {
            LivingEntity entityLivingBase = (LivingEntity)target;
            if (this.canPickupEntity(entityLivingBase)) {
                this.pickupEntity(entityLivingBase);
            }
            if (entityLivingBase instanceof CreeperEntity) {
                entityLivingBase.func_70604_c(null);
                ((CreeperEntity)entityLivingBase).func_70624_b(null);
                this.func_70624_b(null);
            }
        }
        return true;
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(target);
        if (extendedEntity != null && extendedEntity.pickedUpByEntity != null) {
            return false;
        }
        if (!this.creeperDropping && target instanceof CreeperEntity) {
            return false;
        }
        if (this.hasPickupEntity() && target instanceof CreeperEntity) {
            return false;
        }
        if (this.creeperDropCooldown > 0) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public boolean func_213398_dR() {
        if (this.isTamed()) {
            return super.func_213398_dR();
        }
        if (this.func_130014_f_() != null && this.func_130014_f_().func_72935_r()) {
            return this.testLightLevel() < 2;
        }
        return super.func_213398_dR();
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public void pickupEntity(LivingEntity entity) {
        super.pickupEntity(entity);
        if (this.func_130014_f_().func_180495_p(this.func_180425_c()) != null && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            this.leap(0.5, 4.0);
        }
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, -1.0, 0.0};
    }

    @Override
    public boolean canPickupEntity(LivingEntity entity) {
        if (this.creeperDropCooldown > 0 || this.hasPickupEntity()) {
            return false;
        }
        return super.canPickupEntity(entity);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.hasPickupEntity() && this.getPickupEntity() instanceof PlayerEntity) {
            return new BlockPos(wanderPosition.func_177958_n(), this.restrictYHeightFromGround(wanderPosition, 6, 14), wanderPosition.func_177952_p());
        }
        return super.getWanderPosition(wanderPosition);
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.9;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            if (this.getPickupEntity() instanceof CreeperEntity) {
                ((CreeperEntity)this.getPickupEntity()).func_146079_cb();
            }
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        LivingEntity nearestTarget = this.getNearestEntity(LivingEntity.class, null, 4.0, false);
        if (this.canPickupEntity(nearestTarget)) {
            this.pickupEntity(nearestTarget);
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }
}

