/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AvoidTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityQuill;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityQuillbeast
extends EntityCreatureTameable
implements IMob {
    AttackRangedGoal aiAttackRanged;
    AttackMeleeGoal aiAttackMelee;
    AvoidGoal aiAvoid;

    public EntityQuillbeast(EntityType<? extends EntityQuillbeast> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.aiAttackMelee = new AttackMeleeGoal(this).setLongMemory(true).setEnabled(false);
        this.field_70714_bg.func_75776_a(2, (Goal)this.aiAttackMelee);
        this.aiAttackRanged = new AttackRangedGoal(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(10.0f).setChaseTime(-1);
        this.field_70714_bg.func_75776_a(2, (Goal)this.aiAttackRanged);
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.aiAvoid = new AvoidGoal(this).setNearSpeed(1.5).setFarSpeed(1.3).setNearDistance(5.0).setFarDistance(9.0);
        this.field_70714_bg.func_75776_a(5, (Goal)this.aiAvoid);
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupAlpha.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AvoidTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70619_bc() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_70638_az() != this.getAvoidTarget()) {
            this.setAvoidTarget(this.func_70638_az());
        }
        super.func_70619_bc();
    }

    @Override
    public void attackRanged(Entity target, float range) {
        for (int i = -2; i < 12; ++i) {
            EntityQuill projectile = new EntityQuill(ProjectileManager.getInstance().oldProjectileTypes.get(EntityQuill.class), this.func_130014_f_(), (LivingEntity)this);
            projectile.field_70163_u -= (double)(this.func_213305_a((Pose)Pose.STANDING).field_220316_b / 4.0f);
            float accuracy = (float)i * 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
            double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
            double d1 = target.field_70163_u - projectile.field_70163_u + (double)accuracy;
            double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            float velocity = 1.2f;
            projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
            if (i == 0) {
                this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
            this.func_130014_f_().func_217376_c((Entity)projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("vegetables", testStack);
    }
}

