/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.PlayerControlGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderRevengeTargetingGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityQuetzodracl
extends EntityCreatureRideable
implements IMob,
IGroupHunter {
    protected WanderGoal wanderAI;
    protected AttackMeleeGoal attackAI;
    protected int waterTime = 0;
    protected boolean wantsToLand;
    protected boolean isLanded;

    public EntityQuetzodracl(EntityType<? extends EntityQuetzodracl> entityType, World world) {
        super((EntityType<? extends EntityCreatureRideable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.flySoundSpeed = 20;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PlayerControlGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.attackAI = new AttackMeleeGoal(this).setLongMemory(false);
        this.field_70714_bg.func_75776_a(5, (Goal)this.attackAI);
        this.field_70714_bg.func_75776_a(6, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.wanderAI = new WanderGoal(this).setPauseRate(0);
        this.field_70714_bg.func_75776_a(8, (Goal)this.wanderAI);
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RiderRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RiderAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isLanded) {
                this.wantsToLand = false;
                if (this.hasPickupEntity() || this.func_184179_bs() != null || this.func_110167_bD() || this.func_70090_H() || !this.isTamed() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                    this.leap(1.0, 1.0);
                    this.wanderAI.setPauseRate(0);
                    this.isLanded = false;
                }
            } else if (this.wantsToLand) {
                if (!this.isLanded && this.isSafeToLand()) {
                    this.wanderAI.setPauseRate(120);
                    this.isLanded = true;
                }
            } else if (!this.hasPickupEntity() && !this.hasAttackTarget() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                this.wantsToLand = true;
            }
            if (this.hasPickupEntity() || this.func_184179_bs() != null || this.hasAttackTarget() || this.func_70090_H()) {
                this.wantsToLand = false;
            } else if (this.isTamed() && !this.func_110167_bD()) {
                this.wantsToLand = true;
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null) {
            this.attackAI.setEnabled(!this.hasPickupEntity());
            if (!this.func_70090_H()) {
                this.waterTime = 0;
                if (this.hasPickupEntity()) {
                    ExtendedEntity extendedEntity;
                    if (this.updateTick % (long)this.getMeleeCooldown() == 0L) {
                        this.attackMelee((Entity)this.getPickupEntity(), 1.0);
                    }
                    if ((extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity())) != null) {
                        extendedEntity.setPickedUpByEntity((Entity)this);
                    }
                    if (this.field_70173_aa % 100 == 0 && this.func_70681_au().nextBoolean()) {
                        this.dropPickupEntity();
                    }
                }
            } else {
                ++this.waterTime;
                if (this.hasPickupEntity() || this.func_70086_ai() <= 40) {
                    if (this.waterTime >= 40) {
                        this.waterTime = 0;
                        this.leap(0.5, 2.0);
                    }
                } else if (this.hasAttackTarget()) {
                    if (this.waterTime >= 320) {
                        this.waterTime = 80;
                        this.leap(0.5, 2.0);
                    }
                } else if (this.waterTime >= 160) {
                    this.waterTime = 80;
                    this.leap(0.5, 2.0);
                }
            }
        }
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.wantsToLand || !this.isLanded) {
            BlockPos groundPos = wanderPosition.func_177977_b();
            while (groundPos.func_177956_o() > 0 && this.func_130014_f_().func_180495_p(groundPos).func_177230_c() == Blocks.field_150350_a) {
                groundPos = groundPos.func_177977_b();
            }
            if (this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
                return groundPos.func_177984_a();
            }
        }
        if (this.hasPickupEntity() && this.getPickupEntity() instanceof PlayerEntity) {
            wanderPosition = new BlockPos(wanderPosition.func_177958_n(), this.restrictYHeightFromGround(wanderPosition, 6, 14), wanderPosition.func_177952_p());
        }
        return wanderPosition;
    }

    @Override
    public double getFlightOffset() {
        if (!this.wantsToLand) {
            super.getFlightOffset();
        }
        return 0.0;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        LivingEntity entityLivingBase;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof LivingEntity && this.func_184179_bs() == null && this.canPickupEntity(entityLivingBase = (LivingEntity)target)) {
            this.pickupEntity(entityLivingBase);
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return !this.isLanded || this.hasPickupEntity();
    }

    @Override
    public boolean isStrongSwimmer() {
        return false;
    }

    @Override
    public void pickupEntity(LivingEntity entity) {
        super.pickupEntity(entity);
        if (this.func_130014_f_().func_180495_p(this.func_180425_c()) != null && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            this.leap(1.0, 2.0);
        }
    }

    @Override
    public void dropPickupEntity() {
        if (this.hasPickupEntity() && ObjectManager.getEffect("weight") != null) {
            this.getPickupEntity().func_195064_c(new EffectInstance((Effect)ObjectManager.getEffect("weight"), this.getEffectDuration(5), 1));
        }
        super.dropPickupEntity();
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, -1.0, 0.0};
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack) || ObjectLists.inItemList("CookedFish", testStack);
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.8;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        LivingEntity nearestTarget = this.getNearestEntity(LivingEntity.class, null, 4.0, false);
        if (this.canPickupEntity(nearestTarget)) {
            this.pickupEntity(nearestTarget);
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }
}

