/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupDemon;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.MateGoal;
import com.lycanitesmobs.core.entity.goals.actions.PlayerControlGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderRevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityPinky
extends EntityCreatureRideable
implements IGroupAnimal,
IGroupAlpha,
IGroupPredator,
IGroupHunter,
IGroupDemon {
    PlayerControlGoal playerControlAI;

    public EntityPinky(EntityType<? extends EntityPinky> entityType, World world) {
        super((EntityType<? extends EntityCreatureRideable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEAD;
        this.hasAttackSound = true;
        this.spreadFire = true;
        this.setupMob();
        this.attackCooldownMax = 10;
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MateGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackMeleeGoal(this).setTargetClass(ZombiePigmanEntity.class).setSpeed(1.5).setDamage(8.0).setRange(2.5));
        this.field_70714_bg.func_75776_a(6, (Goal)new AttackMeleeGoal(this).setSpeed(1.5));
        this.field_70714_bg.func_75776_a(7, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.playerControlAI = new PlayerControlGoal(this);
        this.field_70714_bg.func_75776_a(9, (Goal)this.playerControlAI);
        this.field_70714_bg.func_75776_a(10, (Goal)new WanderGoal(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RiderRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RiderAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(CowEntity.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(PigEntity.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(SheepEntity.class).setTameTargetting(true));
        }
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(ZombiePigmanEntity.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAlpha.class));
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(AnimalEntity.class));
        }
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().func_201675_m().func_186058_p().func_186068_a() != -1) {
            this.setFarmed();
        }
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        if (rider.func_70644_a(Effects.field_82731_v)) {
            rider.func_195063_d(Effects.field_82731_v);
        }
        if (rider.func_70027_ad()) {
            rider.func_70015_d(0);
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 1.0;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if ((target instanceof AnimalEntity || target instanceof IGroupAnimal) && target.func_213305_a((Pose)Pose.STANDING).field_220316_b < 1.0f) {
            this.breed();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.func_130014_f_().func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(LivingEntity possibleTarget) {
                return possibleTarget.func_70089_S() && possibleTarget != EntityPinky.this && !EntityPinky.this.func_184215_y((Entity)possibleTarget) && !EntityPinky.this.func_184191_r((Entity)possibleTarget) && EntityPinky.this.func_213358_a(possibleTarget.func_200600_R()) && EntityPinky.this.func_213336_c(possibleTarget);
            }
        });
        if (!possibleTargets.isEmpty()) {
            for (LivingEntity possibleTarget : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((PlayerEntity)this.getRider(), (Entity)possibleTarget))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                possibleTarget.func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 0));
            }
        }
        this.playAttackSound();
        this.triggerAttackCooldown();
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        if (!CreatureManager.getInstance().config.predatorsAttackAnimals) {
            return ObjectLists.inItemList("rawmeat", itemStack) || ObjectLists.inItemList("cookedmeat", itemStack);
        }
        return false;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }
}

