/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.BegGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderRevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityMaug
extends EntityCreatureRideable
implements IGroupPredator {
    protected boolean leapedAbilityQueued = false;
    protected boolean leapedAbilityReady = false;

    public EntityMaug(EntityType<? extends EntityMaug> entityType, World world) {
        super((EntityType<? extends EntityCreatureRideable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackMeleeGoal(this).setTargetClass(PlayerEntity.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(6, (Goal)new AttackMeleeGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new FollowParentGoal(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new BegGoal(this));
        this.field_70714_bg.func_75776_a(12, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RiderRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RiderAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAlpha.class).setPackHuntingScale(1, 1));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAnimal.class).setPackHuntingScale(1, 3));
            this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(AnimalEntity.class).setPackHuntingScale(1, 3));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.field_70122_E && !this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(4.0f, 1.0, (Entity)this.func_70638_az());
        }
        if (this.leapedAbilityQueued && !this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = false;
            this.leapedAbilityReady = true;
        }
        if (this.leapedAbilityReady && this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityReady = false;
            double distance = 4.0;
            List possibleTargets = this.func_130014_f_().func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                public boolean apply(LivingEntity possibleTarget) {
                    return possibleTarget.func_70089_S() && possibleTarget != EntityMaug.this && !EntityMaug.this.func_184215_y((Entity)possibleTarget) && !EntityMaug.this.func_184191_r((Entity)possibleTarget) && EntityMaug.this.func_213358_a(possibleTarget.func_200600_R()) && EntityMaug.this.func_213336_c(possibleTarget);
                }
            });
            if (!possibleTargets.isEmpty()) {
                for (LivingEntity possibleTarget : possibleTargets) {
                    boolean doDamage = true;
                    if (this.getRider() instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((PlayerEntity)this.getRider(), (Entity)possibleTarget))) {
                        doDamage = false;
                    }
                    if (!doDamage) continue;
                    possibleTarget.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 0));
                }
            }
            this.playAttackSound();
        }
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        if (rider.func_70644_a(Effects.field_76421_d)) {
            rider.func_195063_d(Effects.field_76421_d);
        }
        if (rider.func_70644_a(Effects.field_76438_s)) {
            rider.func_195063_d(Effects.field_76438_s);
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (!this.field_70122_E) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.95;
    }

    @Override
    public void leap(double distance, double leapHeight) {
        super.leap(distance, leapHeight);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void leap(float range, double leapHeight, Entity target) {
        super.leap(range, leapHeight, target);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (!this.field_70122_E) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.playJumpSound();
        this.leap(2.0, 1.5);
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 15.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("ooze")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

