/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.creature.EntityMakaAlpha;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowMasterGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.MateGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AvoidTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.MasterTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.ParentTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityMaka
extends EntityCreatureAgeable
implements IGroupAnimal {
    public EntityMaka(EntityType<? extends EntityMaka> entityType, World world) {
        super((EntityType<? extends EntityCreatureAgeable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.1;
        this.attackCooldownMax = 10;
        this.fleeHealthPercent = 1.0f;
        this.isAggressiveByDefault = false;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidGoal(this).setNearSpeed(1.3).setFarSpeed(1.2).setNearDistance(5.0).setFarDistance(20.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MateGoal(this).setMateDistance(5.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setItemList("vegetables"));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal(this).setSpeed(1.0).setStrayDistance(3.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowMasterGoal(this).setSpeed(1.0).setStrayDistance(12.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RevengeTargetingGoal(this).setHelpClasses(EntityMakaAlpha.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new ParentTargetingGoal(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(2, (Goal)new MasterTargetingGoal(this).setTargetClass(EntityMakaAlpha.class).setSightCheck(false).setRange(64.0));
        this.field_70715_bh.func_75776_a(3, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupPredator.class));
    }

    @Override
    public void onFirstSpawn() {
        CreatureInfo alphaInfo = CreatureManager.getInstance().getCreature("makaalpha");
        if (alphaInfo != null) {
            float alphaChance = (float)alphaInfo.creatureSpawn.spawnWeight / (float)Math.max(this.creatureInfo.creatureSpawn.spawnWeight, 1);
            if (this.func_70681_au().nextFloat() <= alphaChance) {
                EntityMakaAlpha alpha = (EntityMakaAlpha)CreatureManager.getInstance().getCreature("makaalpha").createEntity(this.func_130014_f_());
                alpha.func_82149_j((Entity)this);
                this.func_130014_f_().func_217376_c((Entity)alpha);
                this.func_70106_y();
            }
        }
        super.onFirstSpawn();
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityMaka || target instanceof EntityMakaAlpha) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("vegetables", testStack);
    }

    @Override
    public void setGrowingAge(int age) {
        if (age == 0 && this.getAge() < 0 && this.func_70681_au().nextFloat() >= 0.9f) {
            EntityMakaAlpha alpha = (EntityMakaAlpha)CreatureManager.getInstance().getCreature("makaalpha").createEntity(this.func_130014_f_());
            alpha.func_82149_j((Entity)this);
            this.func_130014_f_().func_217376_c((Entity)alpha);
            this.func_70106_y();
        }
        super.setGrowingAge(age);
    }
}

