/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.EffectBase;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.BegGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.MateGoal;
import com.lycanitesmobs.core.entity.goals.actions.StealthGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.ParentTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityLurker
extends EntityCreatureTameable
implements IGroupHunter {
    public EntityLurker(EntityType<? extends EntityLurker> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StealthGoal(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidGoal(this).setNearSpeed(2.0).setFarSpeed(1.5).setNearDistance(5.0).setFarDistance(10.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(4, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal(this).setTemptDistanceMin(2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new MateGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowParentGoal(this));
        this.field_70714_bg.func_75776_a(9, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new BegGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(ChickenEntity.class));
            this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        }
        this.field_70715_bh.func_75776_a(0, (Goal)new ParentTargetingGoal(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            EffectBase stalkingEffect = ObjectManager.getEffect("plague");
            if (stalkingEffect != null && this.func_70638_az().func_70644_a((Effect)stalkingEffect)) {
                this.setAvoidTarget(this.func_70638_az());
            } else {
                this.setAvoidTarget(null);
            }
        } else {
            this.setAvoidTarget(null);
        }
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            if (this.hasAttackTarget()) {
                this.leap(6.0f, 0.4, (Entity)this.func_70638_az());
            } else if (this.hasAvoidTarget()) {
                this.leap(4.0, 0.4);
            }
        }
    }

    @Override
    public boolean canStealth() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.hasAttackTarget()) {
            EffectBase stalkingEffect;
            if (this.func_70638_az() instanceof PlayerEntity) {
                PlayerEntity playerTarget = (PlayerEntity)this.func_70638_az();
                ItemStack itemstack = playerTarget.field_71071_by.func_70448_g();
                if (this.isTamingItem(itemstack)) {
                    return false;
                }
            }
            if ((stalkingEffect = ObjectManager.getEffect("plague")) != null && !this.func_70638_az().func_70644_a((Effect)stalkingEffect)) {
                return false;
            }
            if ((double)this.func_70032_d((Entity)this.func_70638_az()) < 25.0) {
                return false;
            }
        } else if (this.isMoving()) {
            return false;
        }
        return true;
    }

    @Override
    public void startStealth() {
        if (this.func_130014_f_().field_72995_K) {
            BasicParticleType particle = ParticleTypes.field_197601_L;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220316_b), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, d0, d1, d2);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(PlayerEntity player) {
        if (this.isTamed() && this.getOwner() == player) {
            return false;
        }
        return this.func_82150_aj();
    }
}

