/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.api.IGroupWater;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByWaterGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityKhalk
extends EntityCreatureTameable
implements IMob,
IGroupFire,
IGroupHeavy {
    public boolean khalkLavaDeath = true;

    public EntityKhalk(EntityType<? extends EntityKhalk> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.01;
        this.solidCollision = true;
        this.setupMob();
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackMeleeGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new StayByWaterGoal(this).setSpeed(1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderGoal(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupIce.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupWater.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(SnowGolemEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPlant.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(6.0f, 0.1, (Entity)this.func_70638_az());
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.lavaContact()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (this.func_130014_f_().func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.lavaContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.khalkLavaDeath && !this.isTamed()) {
            int lavaWidth = (int)Math.floor(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) - 1;
            int lavaHeight = (int)Math.floor(this.func_213305_a((Pose)Pose.STANDING).field_220316_b) - 1;
            for (int x = (int)this.field_70165_t - lavaWidth; x <= (int)this.field_70165_t + lavaWidth; ++x) {
                for (int y = (int)this.field_70163_u; y <= (int)this.field_70163_u + lavaHeight; ++y) {
                    for (int z = (int)this.field_70161_v - lavaWidth; z <= (int)this.field_70161_v + lavaWidth; ++z) {
                        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (block != Blocks.field_150350_a) continue;
                        BlockState blockState = (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(4));
                        if (x == (int)this.field_70165_t && y == (int)this.field_70163_u && z == (int)this.field_70161_v) {
                            blockState = (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(5));
                        }
                        this.func_130014_f_().func_180501_a(new BlockPos(x, y, z), blockState, 3);
                    }
                }
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }

    @Override
    public boolean canBreatheUnderlava() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void applyDropEffects(EntityItemCustom entityitem) {
        entityitem.setCanBurn(false);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

